/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class ChainConveyorBlockEntity$ConnectionStats extends Internal.Record {
        constructor(tangentAngle: number, chainLength: number, start: Vec3d_, end: Vec3d_)
        tangentAngle(): number;
        chainLength(): number;
        end(): Vec3d;
        start(): Vec3d;
    }
    type ChainConveyorBlockEntity$ConnectionStats_ = ChainConveyorBlockEntity$ConnectionStats;
    class Menu extends Internal.MenuItem implements Internal.Accessible, Internal.MenuContainer {
        constructor()
        constructor(arg0: string, arg1: boolean)
        constructor(arg0: string)
        remove(arg0: Internal.MenuComponent_): void;
        removeAll(): void;
        insertSeparator(arg0: number): void;
        /**
         * @deprecated
        */
        countItems(): number;
        add(arg0: Internal.MenuItem_): Internal.MenuItem;
        isTearOff(): boolean;
        getItem(arg0: number): Internal.MenuItem;
        addSeparator(): void;
        insert(arg0: Internal.MenuItem_, arg1: number): void;
        getItemCount(): number;
        remove(arg0: number): void;
        add(arg0: string): void;
        insert(arg0: string, arg1: number): void;
        get tearOff(): boolean
        get itemCount(): number
    }
    type Menu_ = Menu;
    interface LevelReader extends Internal.BlockAndTintGetter, Internal.RenderAttachedBlockView, Internal.SignalGetter, Internal.ChunkView, Internal.BiomeManager$NoiseBiomeSource, Internal.CollisionGetter, Internal.LevelReaderExtensions, Internal.WorldViewMixin, Internal.LevelReaderMixin {
        getControlInputSignal($$0: BlockPos_, $$1: Internal.Direction_, $$2: boolean): number;
        getBlockTint($$0: BlockPos_, $$1: Internal.ColorResolver_): number;
        getMinSection(): number;
        abstract getShade(arg0: Internal.Direction_, arg1: boolean): number;
        findFreePosition($$0: Internal.Entity_, $$1: Internal.VoxelShape_, $$2: Vec3d_, $$3: number, $$4: number, $$5: number): Internal.Optional<Vec3d>;
        getSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        abstract getBlockState(arg0: BlockPos_): Internal.BlockState;
        isUnobstructed($$0: Internal.Entity_, $$1: Internal.VoxelShape_): boolean;
        clipWithInteractionOverride($$0: Vec3d_, $$1: Vec3d_, $$2: BlockPos_, $$3: Internal.VoxelShape_, $$4: Internal.BlockState_): Internal.BlockHitResult;
        getMaxSection(): number;
        getBrightness($$0: Internal.LightLayer_, $$1: BlockPos_): number;
        hasNeighborSignal($$0: BlockPos_): boolean;
        getLightEmission($$0: BlockPos_): number;
        getBlockFloorHeight($$0: BlockPos_): number;
        getBlockStatesIfLoaded($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getSectionYFromSectionIndex($$0: number): number;
        create($$0: number, $$1: number): Internal.LevelHeightAccessor;
        abstract getBiomeManager(): Internal.BiomeManager;
        isEmptyBlock($$0: BlockPos_): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_, $$1: number): number;
        clip($$0: Internal.ClipContext_): Internal.BlockHitResult;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): boolean;
        getBlockCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getRawBrightness($$0: BlockPos_, $$1: number): number;
        getBlockEntity<T extends Internal.BlockEntity>($$0: BlockPos_, $$1: Internal.BlockEntityType_<T>): Internal.Optional<T>;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        /**
         * @deprecated
        */
        hasChunksAt($$0: number, $$1: number, $$2: number, $$3: number): boolean;
        getHeightmapPos($$0: Internal.Heightmap$Types_, $$1: BlockPos_): BlockPos;
        canSeeSky($$0: BlockPos_): boolean;
        abstract enabledFeatures(): Internal.FeatureFlagSet;
        abstract isClientSide(): boolean;
        isUnobstructed($$0: Internal.Entity_): boolean;
        abstract getUncachedNoiseBiome(arg0: number, arg1: number, arg2: number): Internal.Holder<Internal.Biome>;
        getBlockStates($$0: Internal.AABB_): Internal.Stream<Internal.BlockState>;
        getPathfindingCostFromLightLevels($$0: BlockPos_): number;
        abstract dimensionType(): Internal.DimensionType;
        abstract getSkyDarken(): number;
        canSeeSkyFromBelowWater($$0: BlockPos_): boolean;
        holderLookup<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup<T>;
        abstract getHeight(arg0: Internal.Heightmap$Types_, arg1: number, arg2: number): number;
        getMinBuildHeight(): number;
        getSectionsCount(): number;
        getLoadedChunk(chunkX: number, chunkZ: number): Internal.ChunkAccess;
        getSectionIndexFromSectionY($$0: number): number;
        getBiomeFabric(pos: BlockPos_): Internal.Holder<any>;
        getChunk($$0: number, $$1: number, $$2: Internal.ChunkStatus_): Internal.ChunkAccess;
        noCollision($$0: Internal.Entity_): boolean;
        /**
         * @deprecated
        */
        hasChunkAt($$0: number, $$1: number): boolean;
        /**
         * @deprecated
        */
        abstract getSeaLevel(): number;
        getBestNeighborSignal($$0: BlockPos_): number;
        getSectionIndex($$0: number): number;
        getDirectSignalTo($$0: BlockPos_): number;
        /**
         * @deprecated
        */
        abstract hasChunk(arg0: number, arg1: number): boolean;
        getMaxBuildHeight(): number;
        getBlockEntityRenderData(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunksAt($$0: BlockPos_, $$1: BlockPos_): boolean;
        getChunk($$0: number, $$1: number): Internal.ChunkAccess;
        noCollision($$0: Internal.AABB_): boolean;
        isWaterAt($$0: BlockPos_): boolean;
        hasSignal($$0: BlockPos_, $$1: Internal.Direction_): boolean;
        getCollisions($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Iterable<Internal.VoxelShape>;
        getDirectSignal($$0: BlockPos_, $$1: Internal.Direction_): number;
        abstract getLightEngine(): Internal.LevelLightEngine;
        abstract getEntityCollisions(arg0: Internal.Entity_, arg1: Internal.AABB_): Internal.List<Internal.VoxelShape>;
        getBlockFloorHeight($$0: Internal.VoxelShape_, $$1: Internal.Supplier_<Internal.VoxelShape>): number;
        collidesWithSuffocatingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getHeight(): number;
        abstract getBlockEntity(arg0: BlockPos_): Internal.BlockEntity;
        getNoiseBiome($$0: number, $$1: number, $$2: number): Internal.Holder<Internal.Biome>;
        noCollision($$0: Internal.Entity_, $$1: Internal.AABB_): boolean;
        getChunk($$0: BlockPos_): Internal.ChunkAccess;
        abstract getWorldBorder(): Internal.WorldBorder;
        isOutsideBuildHeight($$0: number): boolean;
        getMaxLocalRawBrightness($$0: BlockPos_): number;
        isUnobstructed($$0: Internal.BlockState_, $$1: BlockPos_, $$2: Internal.CollisionContext_): boolean;
        isBlockInLine($$0: Internal.ClipBlockStateContext_): Internal.BlockHitResult;
        abstract getFluidState(arg0: BlockPos_): Internal.FluidState;
        abstract getChunk(arg0: number, arg1: number, arg2: Internal.ChunkStatus_, arg3: boolean): Internal.ChunkAccess;
        abstract registryAccess(): Internal.RegistryAccess;
        findSupportingBlock($$0: Internal.Entity_, $$1: Internal.AABB_): Internal.Optional<BlockPos>;
        /**
         * @deprecated
        */
        getBlockEntityRenderAttachment(pos: BlockPos_): any;
        /**
         * @deprecated
        */
        hasChunkAt($$0: BlockPos_): boolean;
        getBiome($$0: BlockPos_): Internal.Holder<Internal.Biome>;
        getChunkForCollisions($$0: number, $$1: number): Internal.BlockGetter;
        containsAnyLiquid($$0: Internal.AABB_): boolean;
        /**
         * @deprecated
        */
        getLightLevelDependentMagicValue($$0: BlockPos_): number;
        hasBiomes(): boolean;
        getMaxLightLevel(): number;
        isAreaLoaded(center: BlockPos_, range: number): boolean;
        traverseBlocks<T, C>($$0: Vec3d_, $$1: Vec3d_, $$2: C, $$3: Internal.BiFunction_<C, BlockPos, T>, $$4: Internal.Function_<C, T>): T;
        get minSection(): number
        get maxSection(): number
        get biomeManager(): Internal.BiomeManager
        get clientSide(): boolean
        get skyDarken(): number
        get minBuildHeight(): number
        get sectionsCount(): number
        /**
         * @deprecated
        */
        get seaLevel(): number
        get maxBuildHeight(): number
        get lightEngine(): Internal.LevelLightEngine
        get height(): number
        get worldBorder(): Internal.WorldBorder
        get maxLightLevel(): number
    }
    type LevelReader_ = LevelReader;
    class ShortTag extends Internal.NumericTag {
        getType(): Internal.TagType<Internal.ShortTag>;
        getAsString(): string;
        acceptAsRoot($$0: Internal.StreamTagVisitor_): void;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        static valueOf($$0: number): Internal.ShortTag;
        copy(): this;
        get type(): Internal.TagType<Internal.ShortTag>
        get asString(): string
        static readonly TYPE: Internal.TagType<Internal.ShortTag>;
    }
    type ShortTag_ = ShortTag;
    class MudSplatterFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
    }
    type MudSplatterFeature_ = MudSplatterFeature;
    class DoublePlantBlock extends Internal.BushBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static placeAt($$0: Internal.LevelAccessor_, $$1: Internal.BlockState_, $$2: BlockPos_, $$3: number): void;
        static copyWaterloggedFrom($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly HALF: Internal.EnumProperty<Internal.DoubleBlockHalf>;
    }
    type DoublePlantBlock_ = DoublePlantBlock;
    abstract class AbstractContraptionEntity extends Internal.Entity implements Internal.IEntityAdditionalSpawnData, Internal.AccessorAbstractContraptionEntity {
        constructor(entityTypeIn: Internal.EntityType_<any>, worldIn: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        getYawOffset(): number;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        method_5865(passenger: Internal.Entity_, callback: Internal.Entity$MoveFunction_): void;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        startControlling(controlsLocalPos: BlockPos_, player: Internal.Player_): boolean;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        abstract reverseRotation(arg0: Vec3d_, arg1: number): Vec3d;
        getContactPointMotion(globalContactPoint: Vec3d_): Vec3d;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        static build(builder: Internal.FabricEntityTypeBuilder_<any>): Internal.FabricEntityTypeBuilder<any>;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        setContraptionMotion(vec: Vec3d_): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        getContraptionName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        getPrevPositionVec(): Vec3d;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getPassengerPosition(passenger: Internal.Entity_, partialTicks: number): Vec3d;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        supportsTerrainCollision(): boolean;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getAnchorVec(): Vec3d;
        abstract getRotationState(): Internal.AbstractContraptionEntity$ContraptionRotationState;
        abstract applyLocalTransforms(arg0: Internal.PoseStack_, arg1: number): void;
        abstract applyRotation(arg0: Vec3d_, arg1: number): Vec3d;
        move(x: number, y: number, z: number): void;
        tickActors(): void;
        isFrame(): boolean;
        toLocalVector(globalVec: Vec3d_, partialTicks: number, prevAnchor: boolean): Vec3d;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        addSittingPassenger(passenger: Internal.Entity_, seatIndex: number): void;
        toGlobalVector(localVec: Vec3d_, partialTicks: number, prevAnchor: boolean): Vec3d;
        playSound(id: Internal.SoundEvent_): void;
        refreshPSIs(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        handlePlayerInteraction(player: Internal.Player_, localPos: BlockPos_, side: Internal.Direction_, interactionHand: Internal.InteractionHand_): boolean;
        toLocalVector(localVec: Vec3d_, partialTicks: number): Vec3d;
        getDistance(x: number, y: number, z: number): number;
        railways$setSkipActorStop(arg0: boolean): void;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setRotation(yaw: number, pitch: number): void;
        collisionEnabled(): boolean;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        toGlobalVector(localVec: Vec3d_, partialTicks: number): Vec3d;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getControllingPlayer(): Internal.Optional<Internal.UUID>;
        getType(): string;
        self(): Internal.Entity;
        control(controlsLocalPos: BlockPos_, heldControls: Internal.Collection_<number>, player: Internal.Player_): boolean;
        getContraption(): Internal.Contraption;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        isAliveOrStale(): boolean;
        getPassengers(): Internal.EntityArrayList;
        getPrevAnchorVec(): Vec3d;
        sophisticatedInvalidateCaps(): void;
        stopControlling(controlsLocalPos: BlockPos_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isStalled(): boolean;
        alignPassenger(passenger: Internal.Entity_): void;
        disassemble(): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        isReadyForRender(): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        readSpawnData(additionalData: Internal.FriendlyByteBuf_): void;
        isPrevPosInvalid(): boolean;
        railways$moveCollidedEntitiesOnDisassembly(arg0: Internal.StructureTransform_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static pitchFromVector(vec: Vec3d_): number;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        registerColliding(collidingEntity: Internal.Entity_): void;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setBlock(localPos: BlockPos_, newInfo: Internal.StructureTemplate$StructureBlockInfo_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        writeSpawnData(buffer: Internal.FriendlyByteBuf_): void;
        static yawFromVector(vec: Vec3d_): number;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        lithiumOnBlockCacheDeleted(): void;
        setControllingPlayer(playerId: Internal.UUID_): void;
        runCommand(command: string): number;
        get yawOffset(): number
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        set contraptionMotion(vec: Vec3d_)
        get displayName(): net.minecraft.network.chat.Component
        get contraptionName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get prevPositionVec(): Vec3d
        get teamId(): string
        get facing(): Internal.Direction
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get anchorVec(): Vec3d
        get rotationState(): Internal.AbstractContraptionEntity$ContraptionRotationState
        get frame(): boolean
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get controllingPlayer(): Internal.Optional<Internal.UUID>
        get type(): string
        get contraption(): Internal.Contraption
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get aliveOrStale(): boolean
        get passengers(): Internal.EntityArrayList
        get prevAnchorVec(): Vec3d
        get stalled(): boolean
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        get readyForRender(): boolean
        get prevPosInvalid(): boolean
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set dynamicLightEnabled(enabled: boolean)
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set controllingPlayer(playerId: Internal.UUID_)
        staleTicks: number;
        readonly collidingEntities: Internal.Map<Internal.Entity, Internal.MutableInt>;
    }
    type AbstractContraptionEntity_ = AbstractContraptionEntity;
    class ComparatorBlock extends Internal.DiodeBlock implements Internal.EntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        newBlockEntity($$0: BlockPos_, $$1: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly MODE: Internal.EnumProperty<Internal.ComparatorMode>;
    }
    type ComparatorBlock_ = ComparatorBlock;
    class CaveFilter extends Internal.PlacementFilter {
        static readonly CODEC: Internal.Codec<Internal.CaveFilter>;
    }
    type CaveFilter_ = CaveFilter;
    class NarrowTrackBufferBlock extends Internal.WoodVariantTrackBufferBlock {
        constructor(pProperties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.WoodVariantTrackBufferBlockEntity>): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.WoodVariantTrackBufferBlockEntity>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.WoodVariantTrackBufferBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.WoodVariantTrackBufferBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STYLE: Internal.EnumProperty<Internal.NarrowTrackBufferBlock$Style>;
    }
    type NarrowTrackBufferBlock_ = NarrowTrackBufferBlock;
    interface AccessorOrientedContraptionEntity {
        abstract railways$makeStructureTransform(): Internal.StructureTransform;
        (): Internal.StructureTransform_;
    }
    type AccessorOrientedContraptionEntity_ = AccessorOrientedContraptionEntity;
    class XPFluid$Still extends Internal.XPFluid {
        constructor()
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type XPFluid$Still_ = XPFluid$Still;
    class MapExtendingRecipe extends Internal.ShapedRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        static bookshelf$dissolvePattern(pattern: string[], ingredients: Internal.Map_<string, Internal.Ingredient>, width: number, height: number): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getSchema(): Internal.RecipeSchema;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        static bookshelf$shrink(...pattern: string[]): string[];
        static bookshelf$patternFromJson(json: Internal.JsonArray_): string[];
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        static bookshelf$keyFromJson($$0: Internal.JsonObject_): Internal.Map<string, Internal.Ingredient>;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get mod(): string
    }
    type MapExtendingRecipe_ = MapExtendingRecipe;
    abstract class PlacementModifier {
        constructor()
        abstract getPositions(arg0: Internal.PlacementContext_, arg1: Internal.RandomSource_, arg2: BlockPos_): Internal.Stream<BlockPos>;
        abstract type(): Internal.PlacementModifierType<any>;
        static readonly CODEC: Internal.Codec<Internal.PlacementModifier>;
    }
    type PlacementModifier_ = PlacementModifier;
    class EnchantmentMenu extends Internal.AbstractContainerMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: any_)
        constructor($$0: number, $$1: Internal.Inventory_)
        getGoldCount(): number;
        getEnchantmentSeed(): number;
        get goldCount(): number
        get enchantmentSeed(): number
        readonly enchantClue: number[];
        readonly levelClue: number[];
        readonly costs: number[];
    }
    type EnchantmentMenu_ = EnchantmentMenu;
    class PandaSneezeEffect implements Internal.PrestidigitationEffect {
        constructor()
        effectEntity(env: Internal.CastingEnvironment_, entity: Internal.Entity_): void;
        effectBlock(env: Internal.CastingEnvironment_, position: BlockPos_): void;
    }
    type PandaSneezeEffect_ = PandaSneezeEffect;
    class StringSplitter {
        constructor($$0: any_)
        plainIndexAtWidth($$0: string, $$1: number, $$2: Internal.Style_): number;
        findLineBreak($$0: string, $$1: number, $$2: Internal.Style_): number;
        stringWidth($$0: Internal.FormattedText_): number;
        splitLines($$0: Internal.FormattedText_, $$1: number, $$2: Internal.Style_): Internal.List<Internal.FormattedText>;
        stringWidth($$0: string): number;
        static getWordPosition($$0: string, $$1: number, $$2: number, $$3: boolean): number;
        plainTailByWidth($$0: string, $$1: number, $$2: Internal.Style_): string;
        plainHeadByWidth($$0: string, $$1: number, $$2: Internal.Style_): string;
        splitLines($$0: string, $$1: number, $$2: Internal.Style_): Internal.List<Internal.FormattedText>;
        splitLines($$0: string, $$1: number, $$2: Internal.Style_, $$3: boolean, $$4: Internal.StringSplitter$LinePosConsumer_): void;
        headByWidth($$0: Internal.FormattedText_, $$1: number, $$2: Internal.Style_): Internal.FormattedText;
        formattedHeadByWidth($$0: string, $$1: number, $$2: Internal.Style_): string;
        componentStyleAtWidth($$0: Internal.FormattedText_, $$1: number): Internal.Style;
        splitLines($$0: Internal.FormattedText_, $$1: number, $$2: Internal.Style_, $$3: Internal.FormattedText_): Internal.List<Internal.FormattedText>;
        componentStyleAtWidth($$0: Internal.FormattedCharSequence_, $$1: number): Internal.Style;
        stringWidth($$0: Internal.FormattedCharSequence_): number;
        formattedIndexByWidth($$0: string, $$1: number, $$2: Internal.Style_): number;
        splitLines($$0: Internal.FormattedText_, $$1: number, $$2: Internal.Style_, $$3: Internal.BiConsumer_<Internal.FormattedText, boolean>): void;
    }
    type StringSplitter_ = StringSplitter;
    class BlockAkashicRecord extends Internal.Block {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        addNewDatum(herePos: BlockPos_, level: Internal.Level_, key: Internal.HexPattern_, datum: Internal.Iota_): BlockPos;
        lookupPattern(herePos: BlockPos_, key: Internal.HexPattern_, slevel: Internal.ServerLevel_): Internal.Iota;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockAkashicRecord_ = BlockAkashicRecord;
    class SignalBlockEntity$SignalState extends Internal.Enum<Internal.SignalBlockEntity$SignalState> {
        isYellowLight(renderTime: number): boolean;
        static values(): Internal.SignalBlockEntity$SignalState[];
        isGreenLight(renderTime: number): boolean;
        isRedLight(renderTime: number): boolean;
        static valueOf(name: string): Internal.SignalBlockEntity$SignalState;
        static readonly INVALID: Internal.SignalBlockEntity$SignalState;
        static readonly RED: Internal.SignalBlockEntity$SignalState;
        static readonly GREEN: Internal.SignalBlockEntity$SignalState;
        static readonly YELLOW: Internal.SignalBlockEntity$SignalState;
    }
    type SignalBlockEntity$SignalState_ = SignalBlockEntity$SignalState | "yellow" | "red" | "invalid" | "green";
    interface IScreenWrapper extends Internal.IOpenableScreen {
        closeGui(): void;
        openGui(): void;
        closeContextMenu(): void;
        closeGui(openPrevScreen: boolean): void;
        run(): void;
        abstract getGui(): Internal.BaseScreen;
        openAfter(runnable: Internal.Runnable_): Internal.Runnable;
        openGuiLater(): void;
        get gui(): Internal.BaseScreen
        (): Internal.BaseScreen_;
    }
    type IScreenWrapper_ = IScreenWrapper;
    interface CustomJavaToJsWrapperProvider <T> {
        abstract create(arg0: T): Internal.CustomJavaToJsWrapper;
        (arg0: T): Internal.CustomJavaToJsWrapper_;
        readonly NONE: Internal.CustomJavaToJsWrapperProvider<any>;
    }
    type CustomJavaToJsWrapperProvider_<T> = CustomJavaToJsWrapperProvider<T>;
    class PocketPistonItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type PocketPistonItem_ = PocketPistonItem;
    class HangingCobwebBottomBlock extends Internal.HangingStrandBottomBlock {
        constructor(p_i241195_1_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type HangingCobwebBottomBlock_ = HangingCobwebBottomBlock;
    interface TextureAtlasAccessor {
        abstract callGetHeight(): number;
        abstract callGetWidth(): number;
        abstract getMipLevel(): number;
        abstract getTexturesByName(): Internal.Map<ResourceLocation, Internal.TextureAtlasSprite>;
        get mipLevel(): number
        get texturesByName(): Internal.Map<ResourceLocation, Internal.TextureAtlasSprite>
    }
    type TextureAtlasAccessor_ = TextureAtlasAccessor;
    interface ElementType {
        abstract byteAlignment(): number;
        abstract byteSize(): number;
    }
    type ElementType_ = ElementType;
    interface WithPersistentData extends Internal.MessageSenderKJS {
        getDisplayName(): net.minecraft.network.chat.Component;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getPersistentData(): Internal.CompoundTag;
        getName(): net.minecraft.network.chat.Component;
        runCommandSilent(command: string): number;
        tell(message: net.minecraft.network.chat.Component_): void;
        runCommand(command: string): number;
        get displayName(): net.minecraft.network.chat.Component
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get persistentData(): Internal.CompoundTag
        get name(): net.minecraft.network.chat.Component
    }
    type WithPersistentData_ = WithPersistentData;
    class EndRodBlock extends Internal.RodBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type EndRodBlock_ = EndRodBlock;
    class ClientboundOpenBookPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.InteractionHand_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getHand(): Internal.InteractionHand;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get hand(): Internal.InteractionHand
        get skippable(): boolean
    }
    type ClientboundOpenBookPacket_ = ClientboundOpenBookPacket;
    class StringyCobwebBlock extends Internal.Block {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly CONNECTED: Internal.EnumProperty<Internal.ConnectedProperty>;
        static readonly FACING: Internal.DirectionProperty;
    }
    type StringyCobwebBlock_ = StringyCobwebBlock;
    class NetheriteSpaceSuitItem extends Internal.SpaceSuitItem {
        constructor(material: Internal.ArmorMaterial_, type: Internal.ArmorItem$Type_, tankSize: number, properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getFluidContainer(arg0: Internal.ItemStack_): Internal.ItemFluidContainer;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        hasCustomColor($$0: Internal.ItemStack_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static dyeArmor($$0: Internal.ItemStack_, $$1: Internal.List_<Internal.DyeItem>): Internal.ItemStack;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        setColor($$0: Internal.ItemStack_, $$1: number): void;
        emi(amount: number): Internal.EmiStack;
        clearColor($$0: Internal.ItemStack_): void;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type NetheriteSpaceSuitItem_ = NetheriteSpaceSuitItem;
    class WhoopeeCushionItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type WhoopeeCushionItem_ = WhoopeeCushionItem;
    class ClassWrapper <T> extends Internal.Record implements Internal.CustomJavaToJsWrapper {
        constructor(wrappedClass: T)
        convertJavaToJs(cx: Internal.Context_, scope: Internal.Scriptable_, staticType: typeof any): Internal.Scriptable;
        wrappedClass(): T;
    }
    type ClassWrapper_<T> = ClassWrapper<T>;
    interface Object2IntFunction <K> extends Internal.ToIntFunction<K>, it.unimi.dsi.fastutil.Function<K, number> {
        put(arg0: K, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2IntFunction<T>;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Object2FloatFunction<K>;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2IntFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        removeInt(arg0: any): number;
        defaultReturnValue(): number;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2IntFunction;
        apply(arg0: K): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Object2ShortFunction<K>;
        containsKey(arg0: any): boolean;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2IntFunction;
        abstract getInt(arg0: any): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        applyAsInt(arg0: K): number;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2IntFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2IntFunction;
        size(): number;
        defaultReturnValue(arg0: number): void;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2IntFunction;
        clear(): void;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Object2ByteFunction<K>;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        getOrDefault(arg0: any, arg1: number): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2IntFunction;
        identity<T>(): Internal.Function<T, T>;
        (arg0: any): number;
    }
    type Object2IntFunction_<K> = Object2IntFunction<K>;
    interface GeoBlockEntity extends Internal.GeoAnimatable {
        abstract getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        getAnimData<D>(dataTicket: Internal.SerializableDataTicket_<D>): D;
        getBoneResetTime(): number;
        triggerAnim(controllerName: string, animName: string): void;
        abstract registerControllers(arg0: Internal.AnimatableManager$ControllerRegistrar_): void;
        shouldPlayAnimsWhileGamePaused(): boolean;
        stopTriggeredAnim(controllerName: string, animName: string): void;
        setAnimData<D>(dataTicket: Internal.SerializableDataTicket_<D>, data: D): void;
        getTick(blockEntity: any): number;
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
        get boneResetTime(): number
    }
    type GeoBlockEntity_ = GeoBlockEntity;
    interface BiomeFTBC {
        abstract setFTBCBiomeColorIndex(arg0: number): void;
        abstract getFTBCBiomeColorIndex(): number;
        set FTBCBiomeColorIndex(arg0: number)
        get FTBCBiomeColorIndex(): number
    }
    type BiomeFTBC_ = BiomeFTBC;
    class BlockModel$GuiLight extends Internal.Enum<Internal.BlockModel$GuiLight> {
        static getByName($$0: string): Internal.BlockModel$GuiLight;
        lightLikeBlock(): boolean;
        static valueOf($$0: string): Internal.BlockModel$GuiLight;
        static values(): Internal.BlockModel$GuiLight[];
        readonly name: string;
        static readonly SIDE: Internal.BlockModel$GuiLight;
        static readonly FRONT: Internal.BlockModel$GuiLight;
    }
    type BlockModel$GuiLight_ = "side" | BlockModel$GuiLight | "front";
    abstract class EntityPushablePredicate <S> implements Internal.Predicate<S> {
        constructor()
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        or(arg0: Internal.Predicate_<S>): Internal.Predicate<S>;
        and(arg0: Internal.Predicate_<S>): Internal.Predicate<S>;
        abstract test(arg0: S): boolean;
        static and<T>(first: Internal.Predicate_<T>, second: Internal.Predicate_<T>): Internal.Predicate<T>;
        negate(): Internal.Predicate<S>;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
    }
    type EntityPushablePredicate_<S> = EntityPushablePredicate<S>;
    class AgriBlockCondition$Builder {
        constructor()
        strength(strength: number): this;
        tag(namespace: string, path: string): this;
        item(namespace: string, path: string): this;
        tag(location: string): this;
        build(): Internal.AgriBlockCondition;
        item(location: string): this;
        states(...states: string[]): this;
    }
    type AgriBlockCondition$Builder_ = AgriBlockCondition$Builder;
    class BogeySizes$BogeySize extends Internal.Record {
        constructor(id: ResourceLocation_, wheelRadius: number)
        wheelRadius(): number;
        nextBySize(): this;
        id(): ResourceLocation;
    }
    type BogeySizes$BogeySize_ = BogeySizes$BogeySize;
    class MultiBlockItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type MultiBlockItem_ = MultiBlockItem;
    interface MenuAccess <T extends Internal.AbstractContainerMenu> {
        abstract getMenu(): T;
        get menu(): T
        (): T;
    }
    type MenuAccess_<T extends Internal.AbstractContainerMenu> = MenuAccess<T>;
    class WirelessTerminalItem extends Internal.AEBasePoweredItem implements Internal.IMenuItem, Internal.IUpgradeableItem {
        constructor(powerCapacity: Internal.DoubleSupplier_, props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        openFromInventory(player: Internal.Player_, inventorySlot: number): boolean;
        usePower(player: Internal.Player_, amount: number, is: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getLinkedPosition(item: Internal.ItemStack_): Internal.GlobalPos;
        hasPower(player: Internal.Player_, amt: number, is: Internal.ItemStack_): boolean;
        getUpgrades(stack: Internal.ItemStack_): Internal.IUpgradeInventory;
        emi(amount: number): Internal.EmiStack;
        getConfigManager(target: Internal.ItemStack_): Internal.IConfigManager;
        getMenuHost(player: Internal.Player_, inventorySlot: number, stack: Internal.ItemStack_, pos: BlockPos_): Internal.ItemMenuHost;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        getMenuType(): Internal.MenuType<any>;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        getLinkedGrid(item: Internal.ItemStack_, level: Internal.Level_, sendMessagesTo: Internal.Player_): Internal.IGrid;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        get menuType(): Internal.MenuType<any>
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly LINKABLE_HANDLER: Internal.WirelessTerminalItem$LinkableHandler;
    }
    type WirelessTerminalItem_ = WirelessTerminalItem;
    interface PrimitiveIterator <T, T_CONS> extends Internal.Iterator<T> {
        remove(): void;
        abstract forEachRemaining(arg0: T_CONS): void;
        forEachRemaining(arg0: Internal.Consumer_<T>): void;
        abstract next(): T;
        abstract hasNext(): boolean;
    }
    type PrimitiveIterator_<T, T_CONS> = PrimitiveIterator<T, T_CONS>;
    abstract class ProjectileWeaponItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        abstract getDefaultProjectileRange(): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        abstract getAllSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getHeldProjectile($$0: Internal.LivingEntity_, $$1: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        getSupportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get defaultProjectileRange(): number
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get allSupportedProjectiles(): Internal.Predicate<Internal.ItemStack>
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get supportedHeldProjectiles(): Internal.Predicate<Internal.ItemStack>
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly ARROW_OR_FIREWORK: Internal.Predicate<Internal.ItemStack>;
        static readonly ARROW_ONLY: Internal.Predicate<Internal.ItemStack>;
    }
    type ProjectileWeaponItem_ = ProjectileWeaponItem;
    interface PointFreeRule {
        seq(...arg0: Internal.PointFreeRule_[]): this;
        rewriteOrNop<A>(arg0: Internal.PointFree_<A>): Internal.PointFree<A>;
        once(arg0: Internal.PointFreeRule_): this;
        choice(...arg0: Internal.PointFreeRule_[]): this;
        everywhere(arg0: Internal.PointFreeRule_, arg1: Internal.PointFreeRule_): this;
        many(arg0: Internal.PointFreeRule_): this;
        one(arg0: Internal.PointFreeRule_): this;
        all(arg0: Internal.PointFreeRule_): this;
        nop(): this;
        abstract rewrite<A>(arg0: Internal.PointFree_<A>): Internal.Optional<Internal.PointFree<A>>;
        (arg0: Internal.PointFree<A>): Internal.Optional_<Internal.PointFree<A>>;
    }
    type PointFreeRule_ = PointFreeRule;
    interface DoubleSupplier {
        abstract getAsDouble(): number;
        get asDouble(): number
        (): number;
    }
    type DoubleSupplier_ = DoubleSupplier;
    interface FlavorListener extends Internal.EventListener {
        abstract flavorsChanged(arg0: Internal.FlavorEvent_): void;
        (arg0: Internal.FlavorEvent): void;
    }
    type FlavorListener_ = FlavorListener;
    interface Reference2CharFunction <K> extends it.unimi.dsi.fastutil.Function<K, string>, Internal.ToIntFunction<K> {
        put(arg0: K, arg1: string): string;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: string): string;
        removeChar(arg0: any): string;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): string;
        andThenDouble(arg0: Internal.Char2DoubleFunction_): Internal.Reference2DoubleFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, string>;
        andThenLong(arg0: Internal.Char2LongFunction_): Internal.Reference2LongFunction<K>;
        composeDouble(arg0: Internal.Double2ReferenceFunction_<K>): Internal.Double2CharFunction;
        andThenByte(arg0: Internal.Char2ByteFunction_): Internal.Reference2ByteFunction<K>;
        /**
         * @deprecated
        */
        remove(arg0: any): string;
        containsKey(arg0: any): boolean;
        abstract getChar(arg0: any): string;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: string): string;
        composeShort(arg0: Internal.Short2ReferenceFunction_<K>): Internal.Short2CharFunction;
        defaultReturnValue(arg0: string): void;
        /**
         * @deprecated
        */
        get(arg0: any): string;
        composeChar(arg0: Internal.Char2ReferenceFunction_<K>): Internal.Char2CharFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeReference<T>(arg0: Internal.Reference2ReferenceFunction_<T, K>): Internal.Reference2CharFunction<T>;
        andThenInt(arg0: Internal.Char2IntFunction_): Internal.Reference2IntFunction<K>;
        andThenChar(arg0: Internal.Char2CharFunction_): this;
        composeLong(arg0: Internal.Long2ReferenceFunction_<K>): Internal.Long2CharFunction;
        composeObject<T>(arg0: Internal.Object2ReferenceFunction_<T, K>): Internal.Object2CharFunction<T>;
        apply(arg0: K): string;
        andThenReference<T>(arg0: Internal.Char2ReferenceFunction_<T>): Internal.Reference2ReferenceFunction<K, T>;
        andThenObject<T>(arg0: Internal.Char2ObjectFunction_<T>): Internal.Reference2ObjectFunction<K, T>;
        andThenFloat(arg0: Internal.Char2FloatFunction_): Internal.Reference2FloatFunction<K>;
        applyAsInt(arg0: K): number;
        composeByte(arg0: Internal.Byte2ReferenceFunction_<K>): Internal.Byte2CharFunction;
        size(): number;
        composeInt(arg0: Internal.Int2ReferenceFunction_<K>): Internal.Int2CharFunction;
        clear(): void;
        getOrDefault(arg0: any, arg1: string): string;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<string, T>): Internal.Function<K, T>;
        identity<T>(): Internal.Function<T, T>;
        andThenShort(arg0: Internal.Char2ShortFunction_): Internal.Reference2ShortFunction<K>;
        composeFloat(arg0: Internal.Float2ReferenceFunction_<K>): Internal.Float2CharFunction;
        (arg0: any): string;
    }
    type Reference2CharFunction_<K> = Reference2CharFunction<K>;
    abstract class Particle implements Internal.ParticleExtensions, Internal.ParticleAccessor, Internal.EntityDynamicLightSourceBehavior {
        constructor($$0: Internal.ClientLevel_, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number)
        getDynamicLightPrevZ(): number;
        getLifetime(): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        setLifetime($$0: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        getLastDynamicLuminance(): number;
        setPos($$0: number, $$1: number, $$2: number): void;
        isDynamicLightEnabled(): boolean;
        setBoundingBox($$0: Internal.AABB_): void;
        scale($$0: number): this;
        getDynamicLightPrevY(): number;
        getDynamicLightPrevX(): number;
        dynamicLightTick(): void;
        lambdynlights$setTrackedLitChunkPos(trackedLitChunkPos: Internal.LongSet_): void;
        lambdynlights$getTrackedLitChunkPos(): Internal.LongSet;
        abstract getRenderType(): Internal.ParticleRenderType;
        remove(): void;
        setLastDynamicLuminance(luminance: number): void;
        setColor($$0: number, $$1: number, $$2: number): void;
        setDynamicLightEnabled(enabled: boolean): void;
        isAlive(): boolean;
        shouldCull(): boolean;
        getLuminance(): number;
        setLuminance(luminance: number): void;
        getParticleGroup(): Internal.Optional<Internal.ParticleGroup>;
        getDynamicLightX(): number;
        getDynamicLightY(): number;
        getDynamicLightZ(): number;
        abstract render(arg0: Internal.VertexConsumer_, arg1: Internal.Camera_, arg2: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        tick(): void;
        static tickEntity(entity: Internal.Entity_): void;
        port_lib$stoppedByCollision(arg0: boolean): void;
        move($$0: number, $$1: number, $$2: number): void;
        getBoundingBox(): Internal.AABB;
        updateDynamicLightPreviousCoordinates(): void;
        resetDynamicLight(): void;
        setParticleSpeed($$0: number, $$1: number, $$2: number): void;
        setPower($$0: number): this;
        get dynamicLightPrevZ(): number
        get lifetime(): number
        set lifetime($$0: number)
        get lastDynamicLuminance(): number
        get dynamicLightEnabled(): boolean
        set boundingBox($$0: Internal.AABB_)
        get dynamicLightPrevY(): number
        get dynamicLightPrevX(): number
        get renderType(): Internal.ParticleRenderType
        set lastDynamicLuminance(luminance: number)
        set dynamicLightEnabled(enabled: boolean)
        get alive(): boolean
        get luminance(): number
        set luminance(luminance: number)
        get particleGroup(): Internal.Optional<Internal.ParticleGroup>
        get dynamicLightX(): number
        get dynamicLightY(): number
        get dynamicLightZ(): number
        get boundingBox(): Internal.AABB
        set power($$0: number)
        stoppedByCollision: boolean;
    }
    type Particle_ = Particle;
    class FurnaceMenu extends Internal.AbstractFurnaceMenu {
        constructor($$0: number, $$1: Internal.Inventory_, $$2: net.minecraft.world.Container_, $$3: Internal.ContainerData_)
        constructor($$0: number, $$1: Internal.Inventory_)
    }
    type FurnaceMenu_ = FurnaceMenu;
    abstract class FileChannel extends Internal.AbstractInterruptibleChannel implements Internal.SeekableByteChannel, Internal.ScatteringByteChannel, Internal.GatheringByteChannel {
        lock(): Internal.FileLock;
        abstract write(arg0: Internal.ByteBuffer_): number;
        abstract read(arg0: Internal.ByteBuffer_): number;
        static open(arg0: Internal.Path_, arg1: Internal.Set_<Internal.OpenOption>, ...arg2: any_<any>[]): Internal.FileChannel;
        abstract transferFrom(arg0: Internal.ReadableByteChannel_, arg1: number, arg2: number): number;
        abstract lock(arg0: number, arg1: number, arg2: boolean): Internal.FileLock;
        abstract position(): number;
        tryLock(): Internal.FileLock;
        truncate(arg0: number): Internal.SeekableByteChannel;
        abstract size(): number;
        read(arg0: Internal.ByteBuffer_[]): number;
        abstract map(arg0: Internal.FileChannel$MapMode_, arg1: number, arg2: number): Internal.MappedByteBuffer;
        abstract read(arg0: Internal.ByteBuffer_, arg1: number): number;
        abstract read(arg0: Internal.ByteBuffer_[], arg1: number, arg2: number): number;
        abstract position(arg0: number): this;
        abstract write(arg0: Internal.ByteBuffer_[], arg1: number, arg2: number): number;
        static open(arg0: Internal.Path_, ...arg1: Internal.OpenOption_[]): Internal.FileChannel;
        abstract transferTo(arg0: number, arg1: number, arg2: Internal.WritableByteChannel_): number;
        abstract tryLock(arg0: number, arg1: number, arg2: boolean): Internal.FileLock;
        map(arg0: Internal.FileChannel$MapMode_, arg1: number, arg2: number, arg3: Internal.Arena_): Internal.MemorySegment;
        abstract force(arg0: boolean): void;
        write(arg0: Internal.ByteBuffer_[]): number;
        abstract write(arg0: Internal.ByteBuffer_, arg1: number): number;
    }
    type FileChannel_ = FileChannel;
    class AreaSelection {
        constructor(first: BlockPos_, second: BlockPos_)
        toNbt(): Internal.CompoundTag;
        asBoundingBox(): Internal.BoundingBox;
        static fromNbt(tag: Internal.CompoundTag_): Internal.AreaSelection;
        first: BlockPos;
        second: BlockPos;
    }
    type AreaSelection_ = AreaSelection;
    class WorldPreset {
        constructor($$0: Internal.Map_<Internal.ResourceKey<Internal.LevelStem>, Internal.LevelStem>)
        overworld(): Internal.Optional<Internal.LevelStem>;
        createWorldDimensions(): Internal.WorldDimensions;
        static readonly DIRECT_CODEC: Internal.Codec<Internal.WorldPreset>;
        static readonly CODEC: Internal.Codec<Internal.Holder<Internal.WorldPreset>>;
    }
    type WorldPreset_ = WorldPreset | Special.WorldPreset;
    interface IRedstoneInteract {
        abstract getRedstoneMode(): Internal.Redstone;
        abstract setRedstoneMode(arg0: Internal.Redstone_): void;
        nextRedstoneMode(): void;
        get redstoneMode(): Internal.Redstone
        set redstoneMode(arg0: Internal.Redstone_)
    }
    type IRedstoneInteract_ = IRedstoneInteract;
    interface DirectoryStream <T> extends Internal.Closeable, Internal.Iterable<T> {
        forEach(arg0: Internal.Consumer_<T>): void;
        abstract close(): void;
        spliterator(): Internal.Spliterator<T>;
        abstract iterator(): Internal.Iterator<T>;
    }
    type DirectoryStream_<T> = DirectoryStream<T>;
    class ItemFrame extends Internal.HangingEntity implements Internal.ItemFrameEntityKJS, Internal.ItemFrameAccessor {
        constructor($$0: Internal.EntityType_<Internal.ItemFrame>, $$1: Internal.Level_, $$2: BlockPos_, $$3: Internal.Direction_)
        constructor($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.Direction_)
        constructor($$0: Internal.EntityType_<Internal.ItemFrame>, $$1: Internal.Level_)
        getRotateItemSound(): Internal.SoundEvent;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        hasFramedMap(): boolean;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        getAddItemSound(): Internal.SoundEvent;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        setItem($$0: Internal.ItemStack_): void;
        create$getFrameItemStack(): Internal.ItemStack;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        setRotation($$0: number): void;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        setItem($$0: Internal.ItemStack_, $$1: boolean): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getRemoveItemSound(): Internal.SoundEvent;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getFramedMapId(): Internal.OptionalInt;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getRotation(): number;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        getBreakSound(): Internal.SoundEvent;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        getPlaceSound(): Internal.SoundEvent;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getAnalogOutput(): number;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        get rotateItemSound(): Internal.SoundEvent
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get addItemSound(): Internal.SoundEvent
        get monster(): boolean
        set item($$0: Internal.ItemStack_)
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set rotation($$0: number)
        set y(y: number)
        get living(): boolean
        get removeItemSound(): Internal.SoundEvent
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get framedMapId(): Internal.OptionalInt
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        get rotation(): number
        set dynamicLightEnabled(enabled: boolean)
        get breakSound(): Internal.SoundEvent
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        get placeSound(): Internal.SoundEvent
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get analogOutput(): number
        get profile(): Internal.GameProfile
        static readonly DATA_ROTATION: Internal.EntityDataAccessor<number>;
        static readonly NUM_ROTATIONS: 8;
    }
    type ItemFrame_ = ItemFrame;
    interface ItemSteerable {
        abstract boost(): boolean;
        (): boolean;
    }
    type ItemSteerable_ = ItemSteerable;
    class MapColor {
        static getColorFromPackedId($$0: number): number;
        calculateRGBColor($$0: Internal.MapColor$Brightness_): number;
        static byId($$0: number): Internal.MapColor;
        getPackedId($$0: Internal.MapColor$Brightness_): number;
        static readonly FIRE: Internal.MapColor;
        static readonly CRIMSON_NYLIUM: Internal.MapColor;
        static readonly GOLD: Internal.MapColor;
        static readonly DEEPSLATE: Internal.MapColor;
        static readonly TERRACOTTA_GRAY: Internal.MapColor;
        static readonly COLOR_MAGENTA: Internal.MapColor;
        static readonly DIAMOND: Internal.MapColor;
        static readonly COLOR_BLACK: Internal.MapColor;
        static readonly WOOL: Internal.MapColor;
        static readonly RAW_IRON: Internal.MapColor;
        static readonly TERRACOTTA_BROWN: Internal.MapColor;
        readonly id: number;
        static readonly QUARTZ: Internal.MapColor;
        static readonly COLOR_BLUE: Internal.MapColor;
        static readonly WOOD: Internal.MapColor;
        static readonly TERRACOTTA_MAGENTA: Internal.MapColor;
        static readonly COLOR_LIGHT_GREEN: Internal.MapColor;
        static readonly EMERALD: Internal.MapColor;
        static readonly DIRT: Internal.MapColor;
        static readonly COLOR_RED: Internal.MapColor;
        static readonly TERRACOTTA_CYAN: Internal.MapColor;
        static readonly COLOR_GREEN: Internal.MapColor;
        static readonly METAL: Internal.MapColor;
        static readonly WARPED_WART_BLOCK: Internal.MapColor;
        static readonly NETHER: Internal.MapColor;
        static readonly TERRACOTTA_PURPLE: Internal.MapColor;
        static readonly COLOR_GRAY: Internal.MapColor;
        static readonly WARPED_STEM: Internal.MapColor;
        static readonly STONE: Internal.MapColor;
        static readonly COLOR_CYAN: Internal.MapColor;
        static readonly COLOR_LIGHT_GRAY: Internal.MapColor;
        static readonly TERRACOTTA_GREEN: Internal.MapColor;
        static readonly GLOW_LICHEN: Internal.MapColor;
        static readonly COLOR_YELLOW: Internal.MapColor;
        static readonly TERRACOTTA_BLACK: Internal.MapColor;
        static readonly CRIMSON_HYPHAE: Internal.MapColor;
        static readonly COLOR_BROWN: Internal.MapColor;
        static readonly SAND: Internal.MapColor;
        static readonly NONE: Internal.MapColor;
        static readonly ICE: Internal.MapColor;
        static readonly TERRACOTTA_LIGHT_GRAY: Internal.MapColor;
        static readonly COLOR_ORANGE: Internal.MapColor;
        static readonly TERRACOTTA_WHITE: Internal.MapColor;
        static readonly TERRACOTTA_BLUE: Internal.MapColor;
        static readonly WARPED_NYLIUM: Internal.MapColor;
        static readonly PLANT: Internal.MapColor;
        static readonly COLOR_LIGHT_BLUE: Internal.MapColor;
        static readonly LAPIS: Internal.MapColor;
        static readonly TERRACOTTA_YELLOW: Internal.MapColor;
        static readonly CRIMSON_STEM: Internal.MapColor;
        static readonly WARPED_HYPHAE: Internal.MapColor;
        static readonly SNOW: Internal.MapColor;
        static readonly WATER: Internal.MapColor;
        static readonly PODZOL: Internal.MapColor;
        static readonly CLAY: Internal.MapColor;
        static readonly COLOR_PURPLE: Internal.MapColor;
        static readonly GRASS: Internal.MapColor;
        static readonly TERRACOTTA_LIGHT_BLUE: Internal.MapColor;
        static readonly TERRACOTTA_ORANGE: Internal.MapColor;
        static readonly TERRACOTTA_RED: Internal.MapColor;
        static readonly TERRACOTTA_LIGHT_GREEN: Internal.MapColor;
        static readonly COLOR_PINK: Internal.MapColor;
        static readonly TERRACOTTA_PINK: Internal.MapColor;
        readonly col: number;
    }
    type MapColor_ = MapColor;
    class BrainsweepeeIngredient$Type extends Internal.Enum<Internal.BrainsweepeeIngredient$Type> implements Internal.StringRepresentable {
        static values(): Internal.BrainsweepeeIngredient$Type[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.BrainsweepeeIngredient$Type;
        get serializedName(): string
        static readonly ENTITY_TYPE: Internal.BrainsweepeeIngredient$Type;
        static readonly ENTITY_TAG: Internal.BrainsweepeeIngredient$Type;
        static readonly VILLAGER: Internal.BrainsweepeeIngredient$Type;
    }
    type BrainsweepeeIngredient$Type_ = "villager" | "entity_type" | "entity_tag" | BrainsweepeeIngredient$Type;
    class ServerboundPickItemPacket implements Internal.Packet<Internal.ServerGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ServerGamePacketListener_): void;
        getSlot(): number;
        isSkippable(): boolean;
        get slot(): number
        get skippable(): boolean
    }
    type ServerboundPickItemPacket_ = ServerboundPickItemPacket;
    class RestockUpgradeItem extends Internal.UpgradeItemBase<Internal.RestockUpgradeWrapper> {
        constructor(filterSlotCount: Internal.IntSupplier_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getFilterSlotCount(): number;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getType(): Internal.UpgradeType<Internal.RestockUpgradeWrapper>;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get filterSlotCount(): number
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get type(): Internal.UpgradeType<Internal.RestockUpgradeWrapper>
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RestockUpgradeItem_ = RestockUpgradeItem;
    interface OutlineBufferSourceAccessor {
        abstract getField_21059(): Internal.MultiBufferSource$BufferSource;
        get field_21059(): Internal.MultiBufferSource$BufferSource
        (): Internal.MultiBufferSource$BufferSource_;
    }
    type OutlineBufferSourceAccessor_ = OutlineBufferSourceAccessor;
    class ItemHydraArrow extends Internal.ArrowItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemHydraArrow_ = ItemHydraArrow;
    class BlockSetType extends Internal.Record {
        constructor($$0: string, $$1: boolean, $$2: SoundType_, $$3: Internal.SoundEvent_, $$4: Internal.SoundEvent_, $$5: Internal.SoundEvent_, $$6: Internal.SoundEvent_, $$7: Internal.SoundEvent_, $$8: Internal.SoundEvent_, $$9: Internal.SoundEvent_, $$10: Internal.SoundEvent_)
        constructor($$0: string)
        buttonClickOn(): Internal.SoundEvent;
        buttonClickOff(): Internal.SoundEvent;
        static values(): Internal.Stream<Internal.BlockSetType>;
        soundType(): SoundType;
        pressurePlateClickOn(): Internal.SoundEvent;
        name(): string;
        canOpenByHand(): boolean;
        static register($$0: Internal.BlockSetType_): Internal.BlockSetType;
        doorOpen(): Internal.SoundEvent;
        trapdoorClose(): Internal.SoundEvent;
        trapdoorOpen(): Internal.SoundEvent;
        pressurePlateClickOff(): Internal.SoundEvent;
        doorClose(): Internal.SoundEvent;
        static readonly STONE: Internal.BlockSetType;
        static readonly POLISHED_BLACKSTONE: Internal.BlockSetType;
        static readonly GOLD: Internal.BlockSetType;
        static readonly CHERRY: Internal.BlockSetType;
        static readonly BAMBOO: Internal.BlockSetType;
        static readonly SPRUCE: Internal.BlockSetType;
        static readonly OAK: Internal.BlockSetType;
        static readonly BIRCH: Internal.BlockSetType;
        static readonly WARPED: Internal.BlockSetType;
        static readonly DARK_OAK: Internal.BlockSetType;
        static readonly JUNGLE: Internal.BlockSetType;
        static readonly CRIMSON: Internal.BlockSetType;
        static readonly MANGROVE: Internal.BlockSetType;
        static readonly ACACIA: Internal.BlockSetType;
        static readonly IRON: Internal.BlockSetType;
    }
    type BlockSetType_ = BlockSetType;
    class EntityPositionSource$Type implements Internal.PositionSourceType<Internal.EntityPositionSource> {
        constructor()
        write($$0: Internal.FriendlyByteBuf_, $$1: Internal.EntityPositionSource_): void;
        static register<S extends Internal.PositionSourceType<T>, T extends Internal.PositionSource>($$0: string, $$1: S): S;
        static toNetwork<T extends Internal.PositionSource>($$0: T, $$1: Internal.FriendlyByteBuf_): void;
        static fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.PositionSource;
        read(arg0: Internal.FriendlyByteBuf_): Internal.PositionSource;
        codec(): Internal.Codec<Internal.EntityPositionSource>;
        read($$0: Internal.FriendlyByteBuf_): Internal.EntityPositionSource;
        write(arg0: Internal.FriendlyByteBuf_, arg1: Internal.PositionSource_): void;
    }
    type EntityPositionSource$Type_ = EntityPositionSource$Type;
    class DetectorBlock$DetectionType extends Internal.Enum<Internal.DetectorBlock$DetectionType> implements Internal.StringRepresentable {
        static valueOf(name: string): Internal.DetectorBlock$DetectionType;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.DetectorBlock$DetectionType[];
        get serializedName(): string
        static readonly TEMPERATURE: Internal.DetectorBlock$DetectionType;
        static readonly GRAVITY: Internal.DetectorBlock$DetectionType;
        static readonly OXYGEN: Internal.DetectorBlock$DetectionType;
    }
    type DetectorBlock$DetectionType_ = "temperature" | DetectorBlock$DetectionType | "gravity" | "oxygen";
    class EntityStruckByLightningEvent extends Internal.EntityEvents {
        constructor(entity: Internal.Entity_, lightning: Internal.LightningBolt_)
        getLightning(): Internal.LightningBolt;
        get lightning(): Internal.LightningBolt
    }
    type EntityStruckByLightningEvent_ = EntityStruckByLightningEvent;
    interface Externalizable extends Internal.Serializable {
        abstract writeExternal(arg0: Internal.ObjectOutput_): void;
        abstract readExternal(arg0: Internal.ObjectInput_): void;
    }
    type Externalizable_ = Externalizable;
    class BlockPileConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockStateProvider_)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        readonly stateProvider: Internal.BlockStateProvider;
        static readonly CODEC: Internal.Codec<Internal.BlockPileConfiguration>;
    }
    type BlockPileConfiguration_ = BlockPileConfiguration;
    class ShadowSteelItem extends Internal.NoGravMagicalDohickyItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ShadowSteelItem_ = ShadowSteelItem;
    class RedstoneRequesterBlockItem extends Internal.LogisticallyLinkedBlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RedstoneRequesterBlockItem_ = RedstoneRequesterBlockItem;
    interface IPlayer {
        abstract getAnimationStack(): Internal.AnimationStack;
        get animationStack(): Internal.AnimationStack
        (): Internal.AnimationStack_;
    }
    type IPlayer_ = IPlayer;
    interface HolderLookup$Provider {
        abstract lookup<T>(arg0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Optional<Internal.HolderLookup$RegistryLookup<T>>;
        create($$0: Internal.Stream_<Internal.HolderLookup$RegistryLookup<any>>): this;
        lookupOrThrow<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.HolderLookup$RegistryLookup<T>;
        asGetterLookup(): Internal.HolderGetter$Provider;
        (arg0: Internal.ResourceKey<Internal.Registry<T>>): Internal.Optional_<Internal.HolderLookup$RegistryLookup<T>>;
    }
    type HolderLookup$Provider_ = HolderLookup$Provider;
    class EnumArgument <T extends Internal.Enum<T>> implements Internal.ArgumentType<T> {
        getExamples(): Internal.Collection<string>;
        listSuggestions<S>(context: Internal.CommandContext_<S>, builder: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        parse(arg0: Internal.StringReader_): any;
        static enumArgument<R extends Internal.Enum<R>>(enumClass: R): Internal.EnumArgument<R>;
        get examples(): Internal.Collection<string>
    }
    type EnumArgument_<T extends Internal.Enum<T>> = EnumArgument<T>;
    interface CommandSigningContext {
        abstract getArgument(arg0: string): Internal.PlayerChatMessage;
        (arg0: string): Internal.PlayerChatMessage_;
        readonly ANONYMOUS: Internal.CommandSigningContext;
    }
    type CommandSigningContext_ = CommandSigningContext;
    class Screen$NarratableSearchResult {
        constructor($$0: Internal.NarratableEntry_, $$1: number, $$2: Internal.NarratableEntry$NarrationPriority_)
        readonly priority: Internal.NarratableEntry$NarrationPriority;
        readonly entry: Internal.NarratableEntry;
        readonly index: number;
    }
    type Screen$NarratableSearchResult_ = Screen$NarratableSearchResult;
    class ModifierNBT$Builder {
        build(): Internal.ModifierNBT;
        add(modifier: Internal.Modifier_, level: number): this;
        add(entry: Internal.ModifierEntry_): this;
        add(entries: Internal.List_<Internal.ModifierEntry>): this;
        add(nbt: Internal.ModifierNBT_): this;
    }
    type ModifierNBT$Builder_ = ModifierNBT$Builder;
    abstract class IngredientAction extends Internal.IngredientActionFilter {
        constructor()
        abstract getType(): string;
        static getRemaining(container: Internal.CraftingContainer_, index: number, ingredientActions: Internal.List_<Internal.IngredientAction>): Internal.ItemStack;
        abstract transform(arg0: Internal.ItemStack_, arg1: number, arg2: Internal.CraftingContainer_): Internal.ItemStack;
        toJson(json: Internal.JsonObject_): void;
        static parseList(json: Internal.JsonElement_): Internal.List<Internal.IngredientAction>;
        toJson(): Internal.JsonObject;
        static writeList(buf: Internal.FriendlyByteBuf_, list: Internal.List_<Internal.IngredientAction>): void;
        static readList(buf: Internal.FriendlyByteBuf_): Internal.List<Internal.IngredientAction>;
        get type(): string
        static readonly FACTORY_MAP: {"damage": any, "custom": any, "keep": any, "replace": any, "consume": any};
    }
    type IngredientAction_ = IngredientAction;
    class IdentifiedInventory extends Internal.Record {
        constructor(identifier: Internal.InventoryIdentifier_, handler: Internal.Storage_<Internal.ItemVariant>)
        identifier(): Internal.InventoryIdentifier;
        handler(): Internal.Storage<Internal.ItemVariant>;
    }
    type IdentifiedInventory_ = IdentifiedInventory;
    interface GameEventListenerRegistry$ListenerVisitor {
        abstract visit(arg0: Internal.GameEventListener_, arg1: Vec3d_): void;
        (arg0: Internal.GameEventListener, arg1: Vec3d): void;
    }
    type GameEventListenerRegistry$ListenerVisitor_ = GameEventListenerRegistry$ListenerVisitor;
    class NoiseRouter extends Internal.Record {
        constructor($$0: Internal.DensityFunction_, $$1: Internal.DensityFunction_, $$2: Internal.DensityFunction_, $$3: Internal.DensityFunction_, $$4: Internal.DensityFunction_, $$5: Internal.DensityFunction_, $$6: Internal.DensityFunction_, $$7: Internal.DensityFunction_, $$8: Internal.DensityFunction_, $$9: Internal.DensityFunction_, $$10: Internal.DensityFunction_, $$11: Internal.DensityFunction_, $$12: Internal.DensityFunction_, $$13: Internal.DensityFunction_, $$14: Internal.DensityFunction_)
        barrierNoise(): Internal.DensityFunction;
        continents(): Internal.DensityFunction;
        finalDensity(): Internal.DensityFunction;
        veinToggle(): Internal.DensityFunction;
        veinGap(): Internal.DensityFunction;
        initialDensityWithoutJaggedness(): Internal.DensityFunction;
        ridges(): Internal.DensityFunction;
        fluidLevelSpreadNoise(): Internal.DensityFunction;
        lavaNoise(): Internal.DensityFunction;
        temperature(): Internal.DensityFunction;
        veinRidged(): Internal.DensityFunction;
        mapAll($$0: Internal.DensityFunction$Visitor_): this;
        depth(): Internal.DensityFunction;
        fluidLevelFloodednessNoise(): Internal.DensityFunction;
        erosion(): Internal.DensityFunction;
        vegetation(): Internal.DensityFunction;
        static readonly CODEC: Internal.Codec<Internal.NoiseRouter>;
    }
    type NoiseRouter_ = NoiseRouter;
    class FallLocation extends Internal.Record {
        constructor($$0: string)
        id(): string;
        languageKey(): string;
        static blockToFallLocation($$0: Internal.BlockState_): Internal.FallLocation;
        static getCurrentFallLocation($$0: Internal.LivingEntity_): Internal.FallLocation;
        static readonly OTHER_CLIMBABLE: Internal.FallLocation;
        static readonly WATER: Internal.FallLocation;
        static readonly GENERIC: Internal.FallLocation;
        static readonly WEEPING_VINES: Internal.FallLocation;
        static readonly VINES: Internal.FallLocation;
        static readonly SCAFFOLDING: Internal.FallLocation;
        static readonly LADDER: Internal.FallLocation;
        static readonly TWISTING_VINES: Internal.FallLocation;
    }
    type FallLocation_ = FallLocation;
    interface BlockEntityRendererProvider <T extends Internal.BlockEntity> {
        abstract create(arg0: Internal.BlockEntityRendererProvider$Context_): Internal.BlockEntityRenderer<T>;
        (arg0: Internal.BlockEntityRendererProvider$Context): Internal.BlockEntityRenderer_<T>;
    }
    type BlockEntityRendererProvider_<T extends Internal.BlockEntity> = BlockEntityRendererProvider<T>;
    interface Int2ByteFunction extends Internal.IntUnaryOperator, it.unimi.dsi.fastutil.Function<number, number> {
        andThenInt(arg0: Internal.Byte2IntFunction_): Internal.Int2IntFunction;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2ByteFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenFloat(arg0: Internal.Byte2FloatFunction_): Internal.Int2FloatFunction;
        andThenByte(arg0: Internal.Byte2ByteFunction_): this;
        containsKey(arg0: number): boolean;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        andThenDouble(arg0: Internal.Byte2DoubleFunction_): Internal.Int2DoubleFunction;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        getOrDefault(arg0: number, arg1: number): number;
        defaultReturnValue(arg0: number): void;
        andThenReference<T>(arg0: Internal.Byte2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        andThenChar(arg0: Internal.Byte2CharFunction_): Internal.Int2CharFunction;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2ByteFunction;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        applyAsInt(arg0: number): number;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2ByteFunction<T>;
        apply(arg0: number): number;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2ByteFunction;
        andThenObject<T>(arg0: Internal.Byte2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2ByteFunction<T>;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        abstract get(arg0: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        remove(arg0: number): number;
        put(arg0: number, arg1: number): number;
        andThenShort(arg0: Internal.Byte2ShortFunction_): Internal.Int2ShortFunction;
        size(): number;
        andThenLong(arg0: Internal.Byte2LongFunction_): Internal.Int2LongFunction;
        clear(): void;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2ByteFunction;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2ByteFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2ByteFunction;
        (arg0: number): number;
    }
    type Int2ByteFunction_ = Int2ByteFunction;
    interface Char2LongFunction extends it.unimi.dsi.fastutil.Function<string, number>, Internal.IntToLongFunction {
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2LongFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<string, T>;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: number): number;
        andThenDouble(arg0: Internal.Long2DoubleFunction_): Internal.Char2DoubleFunction;
        andThenChar(arg0: Internal.Long2CharFunction_): Internal.Char2CharFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        andThenInt(arg0: Internal.Long2IntFunction_): Internal.Char2IntFunction;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2LongFunction;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2LongFunction;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, number>;
        abstract get(arg0: string): number;
        put(arg0: string, arg1: number): number;
        andThenReference<T>(arg0: Internal.Long2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        containsKey(arg0: string): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenObject<T>(arg0: Internal.Long2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        getOrDefault(arg0: string, arg1: number): number;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2LongFunction;
        andThenFloat(arg0: Internal.Long2FloatFunction_): Internal.Char2FloatFunction;
        andThenByte(arg0: Internal.Long2ByteFunction_): Internal.Char2ByteFunction;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2LongFunction;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2LongFunction<T>;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2LongFunction<T>;
        defaultReturnValue(): number;
        remove(arg0: string): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        apply(arg0: string): number;
        andThenShort(arg0: Internal.Long2ShortFunction_): Internal.Char2ShortFunction;
        size(): number;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2LongFunction;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        /**
         * @deprecated
        */
        applyAsLong(arg0: number): number;
        andThenLong(arg0: Internal.Long2LongFunction_): this;
        clear(): void;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: number): void;
        (arg0: string): number;
    }
    type Char2LongFunction_ = Char2LongFunction;
    class SpawnEggItem extends Internal.Item implements Internal.SpawnEggItemAccessor {
        constructor($$0: Internal.EntityType_<Internal.Mob>, $$1: number, $$2: number, $$3: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static byId($$0: Internal.EntityType_<any>): Internal.SpawnEggItem;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getColor($$0: number): number;
        static getEggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        spawnOffspringFromSpawnEgg($$0: Internal.Player_, $$1: Internal.Mob_, $$2: Internal.EntityType_<Internal.Mob>, $$3: Internal.ServerLevel_, $$4: Vec3d_, $$5: Internal.ItemStack_): Internal.Optional<Internal.Mob>;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        spawnsEntity($$0: Internal.CompoundTag_, $$1: Internal.EntityType_<any>): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static eggs(): Internal.Iterable<Internal.SpawnEggItem>;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        getType($$0: Internal.CompoundTag_): Internal.EntityType<any>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        static "getEggMap$registrate-fabric_$md$fca01f$1"(): Internal.Map<any, any>;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get eggMap(): Internal.Map<Internal.EntityType<any>, Internal.SpawnEggItem>
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        get "eggMap$registrate-fabric_$md$fca01f$1"(): Internal.Map<any, any>
        set armorKnockbackResistance(knockbackResistance: number)
        defaultType: Internal.EntityType<any>;
        static readonly BY_ID: {[key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, null: Internal.LazySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.ArchitecturySpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem, [key: Internal.EntityType<any>]: Internal.SpawnEggItem, [key: Internal.FabricEntityType<any>]: Internal.ChickenSpawnEggItem};
    }
    type SpawnEggItem_ = SpawnEggItem;
    interface InjectedFluidExtension extends Internal.InjectedRegistryEntryExtension<Internal.Fluid> {
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type InjectedFluidExtension_ = InjectedFluidExtension;
    class SlimeBlock extends Internal.HalfTransparentBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SlimeBlock_ = SlimeBlock;
    class ClientboundSetBorderCenterPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.WorldBorder_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getNewCenterX(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getNewCenterZ(): number;
        isSkippable(): boolean;
        get newCenterX(): number
        get newCenterZ(): number
        get skippable(): boolean
    }
    type ClientboundSetBorderCenterPacket_ = ClientboundSetBorderCenterPacket;
    class AbuseReportRequest$RealmInfo {
        constructor(arg0: string, arg1: number)
        slotId: number;
        realmId: string;
    }
    type AbuseReportRequest$RealmInfo_ = AbuseReportRequest$RealmInfo;
    class BuddingBushBlock extends Internal.BushBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        growPastMaxAge(state: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, random: Internal.RandomSource_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getStateForAge(age: number): Internal.BlockState;
        setLightEmission(v: number): void;
        isMaxAge(state: Internal.BlockState_): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getAgeProperty(): Internal.IntegerProperty;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        canGrowPastMaxAge(): boolean;
        emi(): Internal.EmiStack;
        getMaxAge(): number;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get ageProperty(): Internal.IntegerProperty
        get maxAge(): number
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 3;
    }
    type BuddingBushBlock_ = BuddingBushBlock;
    class ChunkEntities <T> {
        constructor($$0: Internal.ChunkPos_, $$1: Internal.List_<T>)
        getPos(): Internal.ChunkPos;
        isEmpty(): boolean;
        getEntities(): Internal.Stream<T>;
        get pos(): Internal.ChunkPos
        get empty(): boolean
        get entities(): Internal.Stream<T>
    }
    type ChunkEntities_<T> = ChunkEntities<T>;
    class ConnectedInputHandler$ConnectedInput {
        constructor()
        attachTo(controllerPos: BlockPos_, myPos: BlockPos_): void;
        read(nbt: Internal.CompoundTag_): void;
        getInventories(world: Internal.Level_, pos: BlockPos_): Internal.List<Internal.MechanicalCrafterBlockEntity$Inventory>;
        write(nbt: Internal.CompoundTag_): void;
        getItemHandler(world: Internal.Level_, pos: BlockPos_): Internal.CombinedStorage<Internal.ItemVariant, Internal.MechanicalCrafterBlockEntity$Inventory>;
    }
    type ConnectedInputHandler$ConnectedInput_ = ConnectedInputHandler$ConnectedInput;
    class LootContext implements Internal.LootContextAccessor, Internal.LootContextExtensions {
        getParamOrNull<T>($$0: Internal.LootContextParam_<T>): T;
        getLootingModifier(): number;
        getResolver(): Internal.LootDataResolver;
        getLevel(): Internal.ServerLevel;
        static createVisitedEntry($$0: Internal.LootItemCondition_): Internal.LootContext$VisitedEntry<Internal.LootItemCondition>;
        getParam<T>($$0: Internal.LootContextParam_<T>): T;
        setQueriedLootTableId(queriedLootTableId: ResourceLocation_): void;
        getQueriedLootTableId(): ResourceLocation;
        static createVisitedEntry($$0: Internal.LootItemFunction_): Internal.LootContext$VisitedEntry<Internal.LootItemFunction>;
        getLuck(): number;
        static createVisitedEntry($$0: Internal.LootTable_): Internal.LootContext$VisitedEntry<Internal.LootTable>;
        hasParam($$0: Internal.LootContextParam_<any>): boolean;
        popVisitedElement($$0: Internal.LootContext$VisitedEntry_<any>): void;
        hasVisitedElement($$0: Internal.LootContext$VisitedEntry_<any>): boolean;
        getRandom(): Internal.RandomSource;
        addDynamicDrops($$0: ResourceLocation_, $$1: Internal.Consumer_<Internal.ItemStack>): void;
        pushVisitedElement($$0: Internal.LootContext$VisitedEntry_<any>): boolean;
        getParams(): Internal.LootParams;
        get lootingModifier(): number
        get resolver(): Internal.LootDataResolver
        get level(): Internal.ServerLevel
        set queriedLootTableId(queriedLootTableId: ResourceLocation_)
        get queriedLootTableId(): ResourceLocation
        get luck(): number
        get random(): Internal.RandomSource
        get params(): Internal.LootParams
    }
    type LootContext_ = LootContext;
    abstract class AEKeyType {
        constructor(id: ResourceLocation_, keyClass: typeof Internal.AEKey, description: net.minecraft.network.chat.Component_)
        abstract loadKeyFromTag(arg0: Internal.CompoundTag_): Internal.AEKey;
        getUnitSymbol(): string;
        getAmountPerByte(): number;
        supportsFuzzyRangeSearch(): boolean;
        static fluids(): Internal.AEKeyType;
        formatAmount(amount: number, format: Internal.AmountFormat_): string;
        abstract readFromPacket(arg0: Internal.FriendlyByteBuf_): Internal.AEKey;
        contains(key: Internal.AEKey_): boolean;
        getRawId(): number;
        static fromRawId(id: number): Internal.AEKeyType;
        tryCast(key: Internal.AEKey_): Internal.AEKey;
        getAmountPerOperation(): number;
        getKeyClass(): typeof Internal.AEKey;
        getAmountPerUnit(): number;
        static items(): Internal.AEKeyType;
        getId(): ResourceLocation;
        getTagNames(): Internal.Stream<Internal.TagKey<any>>;
        filter(): Internal.AEKeyFilter;
        getDescription(): net.minecraft.network.chat.Component;
        get unitSymbol(): string
        get amountPerByte(): number
        get rawId(): number
        get amountPerOperation(): number
        get keyClass(): typeof Internal.AEKey
        get amountPerUnit(): number
        get id(): ResourceLocation
        get tagNames(): Internal.Stream<Internal.TagKey<any>>
        get description(): net.minecraft.network.chat.Component
    }
    type AEKeyType_ = AEKeyType | Special.Keytypes;
    class ArrowPiercingEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
        method_8180($$0: Internal.Enchantment_): boolean;
    }
    type ArrowPiercingEnchantment_ = ArrowPiercingEnchantment;
    class ClientboundPingPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getId(): number;
        get skippable(): boolean
        get id(): number
    }
    type ClientboundPingPacket_ = ClientboundPingPacket;
    interface ICarriageConductors {
        abstract railways$getControllingConductors(): Internal.List<Internal.UUID>;
        (): Internal.List_<Internal.UUID>;
    }
    type ICarriageConductors_ = ICarriageConductors;
    class TrackObserverBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.TrackObserverBlockEntity>, Internal.ConnectableRedstoneBlock {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityClass(): typeof Internal.TrackObserverBlockEntity;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TrackObserverBlockEntity>): void;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TrackObserverBlockEntity;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TrackObserverBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TrackObserverBlockEntity>;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.TrackObserverBlockEntity>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityClass(): typeof Internal.TrackObserverBlockEntity
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.TrackObserverBlockEntity>
        static readonly POWERED: Internal.BooleanProperty;
    }
    type TrackObserverBlock_ = TrackObserverBlock;
    class DoubleArithmetic implements Internal.Arithmetic {
        getOperator(pattern: Internal.HexPattern_): Internal.Operator;
        opTypes(): Internal.List<Internal.HexPattern>;
        getACCEPTS(): Internal.IotaMultiPredicate;
        make2(op: Internal.DoubleBinaryOperator_): Internal.OperatorBinary;
        make1(op: Internal.DoubleUnaryOperator_): Internal.OperatorUnary;
        arithName(): string;
        get ACCEPTS(): Internal.IotaMultiPredicate
        static readonly OPS: [Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern, Internal.HexPattern];
        static readonly INSTANCE: Internal.DoubleArithmetic;
    }
    type DoubleArithmetic_ = DoubleArithmetic;
    class ShaderInstance implements Internal.ShaderProgramAccessor, Internal.ShaderInstanceInterface, Internal.Shader, Internal.AutoCloseable {
        constructor($$0: Internal.ResourceProvider_, $$1: string, $$2: Internal.VertexFormat_)
        markDirty(): void;
        owo$getLoadedUniforms(): Internal.Map<any, any>;
        static parseBlendNode($$0: Internal.JsonObject_): Internal.BlendMode;
        attachToProgram(): void;
        getVertexProgram(): Internal.Program;
        setSampler($$0: string, $$1: any): void;
        handler$dkg000$iris$setupGeometryShader(resourceProvider: Internal.ResourceProvider_, string: string, vertexFormat: Internal.VertexFormat_, ci: Internal.CallbackInfo_): void;
        apply(): void;
        getFragmentProgram(): Internal.Program;
        getUniform($$0: string): Internal.Uniform;
        getVertexFormat(): Internal.VertexFormat;
        close(): void;
        clear(): void;
        getName(): string;
        redirect$dkg000$iris$redirectBindAttributeLocation(i: number, j: number, charSequence: Internal.CharSequence_): void;
        safeGetUniform($$0: string): Internal.AbstractUniform;
        iris$createExtraShaders(provider: Internal.ResourceProvider_, name: string): void;
        getId(): number;
        get vertexProgram(): Internal.Program
        get fragmentProgram(): Internal.Program
        get vertexFormat(): Internal.VertexFormat
        get name(): string
        get id(): number
        readonly LINE_WIDTH: Internal.Uniform;
        readonly SCREEN_SIZE: Internal.Uniform;
        TEXTURE_MATRIX: Internal.Uniform;
        COLOR_MODULATOR: Internal.Uniform;
        readonly LIGHT1_DIRECTION: Internal.Uniform;
        readonly FOG_COLOR: Internal.Uniform;
        readonly INVERSE_VIEW_ROTATION_MATRIX: Internal.Uniform;
        static readonly SHADER_PATH: "shaders";
        readonly GLINT_ALPHA: Internal.Uniform;
        readonly LIGHT0_DIRECTION: Internal.Uniform;
        PROJECTION_MATRIX: Internal.Uniform;
        readonly FOG_START: Internal.Uniform;
        readonly FOG_END: Internal.Uniform;
        CHUNK_OFFSET: Internal.Uniform;
        readonly FOG_SHAPE: Internal.Uniform;
        MODEL_VIEW_MATRIX: Internal.Uniform;
        readonly GAME_TIME: Internal.Uniform;
        readonly uniforms: Internal.List<Internal.Uniform>;
    }
    type ShaderInstance_ = ShaderInstance;
    abstract class MultiblockController extends Internal.Block implements Internal.MultiblockPart$MultiblockMainPart {
        constructor(p_49795_: Internal.BlockBehaviour$Properties_)
        getSize(facing: Internal.Direction_): Vec3i;
        abstract onActivate(arg0: Internal.BlockState_, arg1: Internal.Level_, arg2: BlockPos_, arg3: Internal.Player_, arg4: Internal.InteractionHand_, arg5: Internal.BlockHitResult_): Internal.InteractionResult;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickBlock(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): Internal.ItemStack;
        getPartTypeAt(facing: Internal.Direction_, x: number, y: number, z: number): Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static propsGhost(): Internal.NonNullUnaryOperator<Internal.BlockBehaviour$Properties>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getGhostDirection(facing: Internal.Direction_, xIn: number, yIn: number, zIn: number): Internal.Direction;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        abstract getStart(arg0: Internal.Direction_): Vec3i;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockRotation(facing: Internal.Direction_, part: Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType_): Internal.Direction;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static props(): Internal.NonNullUnaryOperator<Internal.BlockBehaviour$Properties>;
        abstract getMultiblockLayout(): Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType[][][];
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get multiblockLayout(): Internal.MultiblockPart$MultiblockMainPart$MultiblockPartType[][][]
    }
    type MultiblockController_ = MultiblockController;
    class AccessFlag$Location extends Internal.Enum<Internal.AccessFlag$Location> {
        static valueOf(arg0: string): Internal.AccessFlag$Location;
        static values(): Internal.AccessFlag$Location[];
        static readonly MODULE: Internal.AccessFlag$Location;
        static readonly MODULE_OPENS: Internal.AccessFlag$Location;
        static readonly METHOD: Internal.AccessFlag$Location;
        static readonly CLASS: Internal.AccessFlag$Location;
        static readonly FIELD: Internal.AccessFlag$Location;
        static readonly MODULE_REQUIRES: Internal.AccessFlag$Location;
        static readonly INNER_CLASS: Internal.AccessFlag$Location;
        static readonly METHOD_PARAMETER: Internal.AccessFlag$Location;
        static readonly MODULE_EXPORTS: Internal.AccessFlag$Location;
    }
    type AccessFlag$Location_ = "field" | "method" | "module" | "method_parameter" | "module_exports" | "module_requires" | AccessFlag$Location | "inner_class" | "module_opens" | "class";
    class CubeListBuilder {
        constructor()
        addBox($$0: string, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number): this;
        addBox($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number): this;
        addBox($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: Internal.Set_<Internal.Direction>): this;
        static create(): Internal.CubeListBuilder;
        getCubes(): Internal.List<Internal.CubeDefinition>;
        texOffs($$0: number, $$1: number): this;
        addBox($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: Internal.CubeDeformation_, $$7: number, $$8: number): this;
        mirror(): this;
        mirror($$0: boolean): this;
        addBox($$0: string, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number): this;
        addBox($$0: string, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: Internal.CubeDeformation_, $$8: number, $$9: number): this;
        addBox($$0: string, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: Internal.CubeDeformation_): this;
        addBox($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: Internal.CubeDeformation_): this;
        addBox($$0: number, $$1: number, $$2: number, $$3: number, $$4: number, $$5: number, $$6: boolean): this;
        get cubes(): Internal.List<Internal.CubeDefinition>
    }
    type CubeListBuilder_ = CubeListBuilder;
    interface IntToDoubleFunction {
        abstract applyAsDouble(arg0: number): number;
        (arg0: number): number;
    }
    type IntToDoubleFunction_ = IntToDoubleFunction;
    class SimpleBlockFeature extends Internal.Feature<Internal.SimpleBlockConfiguration> {
        constructor($$0: Internal.Codec_<Internal.SimpleBlockConfiguration>)
    }
    type SimpleBlockFeature_ = SimpleBlockFeature;
    class FlapDisplayBlockEntity extends Internal.KineticBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getLineColor(line: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        initDefaultSections(): void;
        onLoad(): void;
        getLineIndexAt(yCoord: number): number;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        setColour(lineIndex: number, color: Internal.DyeColor_): void;
        invalidateCaps(): void;
        getController(): this;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setGlowing(lineIndex: number): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getLines(): Internal.List<Internal.FlapDisplayLayout>;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getMaxCharCount(gaps: number): number;
        isLineGlowing(line: number): boolean;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        applyTextManually(lineIndex: number, rawComponentText: string): void;
        getDirection(): Internal.Direction;
        getMaxCharCount(): number;
        updateControllerStatus(): void;
        getRenderBoundingBox(): Internal.AABB;
        get controller(): Internal.FlapDisplayBlockEntity
        set glowing(lineIndex: number)
        get infiniteBoundingBox(): Internal.AABB
        get lines(): Internal.List<Internal.FlapDisplayLayout>
        get direction(): Internal.Direction
        get maxCharCount(): number
        get renderBoundingBox(): Internal.AABB
        lines: Internal.List<Internal.FlapDisplayLayout>;
        manualLines: boolean[];
        isRunning: boolean;
        colour: Internal.DyeColor[];
        ySize: number;
        isController: boolean;
        xSize: number;
        glowingLines: boolean[];
    }
    type FlapDisplayBlockEntity_ = FlapDisplayBlockEntity;
    class ClientboundSoundEntityPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Holder_<Internal.SoundEvent>, $$1: Internal.SoundSource_, $$2: Internal.Entity_, $$3: number, $$4: number, $$5: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getVolume(): number;
        getSound(): Internal.Holder<Internal.SoundEvent>;
        write($$0: Internal.FriendlyByteBuf_): void;
        getSource(): Internal.SoundSource;
        getPitch(): number;
        getSeed(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getId(): number;
        get volume(): number
        get sound(): Internal.Holder<Internal.SoundEvent>
        get source(): Internal.SoundSource
        get pitch(): number
        get seed(): number
        get skippable(): boolean
        get id(): number
    }
    type ClientboundSoundEntityPacket_ = ClientboundSoundEntityPacket;
    class DeathMessageType extends Internal.Enum<Internal.DeathMessageType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.DeathMessageType[];
        static valueOf($$0: string): Internal.DeathMessageType;
        get serializedName(): string
        static readonly DEFAULT: Internal.DeathMessageType;
        static readonly INTENTIONAL_GAME_DESIGN: Internal.DeathMessageType;
        static readonly FALL_VARIANTS: Internal.DeathMessageType;
        static readonly CODEC: Internal.Codec<Internal.DeathMessageType>;
    }
    type DeathMessageType_ = "fall_variants" | "intentional_game_design" | "default" | DeathMessageType;
    class DefaultedMappedRegistry <T> extends Internal.MappedRegistry<T> implements Internal.DefaultedRegistry<T> {
        constructor($$0: string, $$1: Internal.ResourceKey_<Internal.Registry<T>>, $$2: Internal.Lifecycle_, $$3: boolean)
        asHolderIdMap(): Internal.IdMap<Internal.Holder<T>>;
        static registerMapping<V, T extends V>($$0: Internal.Registry_<V>, $$1: number, $$2: string, $$3: T): T;
        registerMapping($$0: number, $$1: Internal.ResourceKey_<T>, $$2: T, $$3: Internal.Lifecycle_): Internal.Holder$Reference<T>;
        getHolderOrThrow($$0: Internal.ResourceKey_<T>): Internal.Holder$Reference<T>;
        spliterator(): Internal.Spliterator<T>;
        keys<U>($$0: Internal.DynamicOps_<U>): Internal.Stream<U>;
        get($$0: ResourceLocation_): T;
        byIdOrThrow($$0: number): T;
        static registerForHolder<T>($$0: Internal.Registry_<T>, $$1: Internal.ResourceKey_<T>, $$2: T): Internal.Holder$Reference<T>;
        forEach(arg0: Internal.Consumer_<T>): void;
        getTagOrEmpty($$0: Internal.TagKey_<T>): Internal.Iterable<Internal.Holder<T>>;
        getRandom($$0: Internal.RandomSource_): Internal.Optional<Internal.Holder$Reference<T>>;
        holderByNameCodec(): Internal.Codec<Internal.Holder<T>>;
        static register<V, T extends V>($$0: Internal.Registry_<V>, $$1: Internal.ResourceKey_<V>, $$2: T): T;
        byId($$0: number): T;
        getDefaultKey(): ResourceLocation;
        static get<T>(registry: Internal.Registry_<T>): Internal.ListenableRegistry<T>;
        static registerForHolder<T>($$0: Internal.Registry_<T>, $$1: ResourceLocation_, $$2: T): Internal.Holder$Reference<T>;
        asTagAddingLookup(): Internal.HolderLookup$RegistryLookup<T>;
        static register<T>($$0: Internal.Registry_<T>, $$1: string, $$2: T): T;
        stream(): Internal.Stream<T>;
        getOptional($$0: Internal.ResourceKey_<T>): Internal.Optional<T>;
        getOptional($$0: ResourceLocation_): Internal.Optional<T>;
        static forStrings(arg0: Internal.Supplier_<Internal.Stream<string>>): Internal.Keyable;
        static register<V, T extends V>($$0: Internal.Registry_<V>, $$1: ResourceLocation_, $$2: T): T;
        getOrThrow($$0: Internal.ResourceKey_<T>): T;
        byNameCodec(): Internal.Codec<T>;
        get defaultKey(): ResourceLocation
    }
    type DefaultedMappedRegistry_<T> = DefaultedMappedRegistry<T>;
    class SpriteLoader$Preparations extends Internal.Record {
        constructor($$0: number, $$1: number, $$2: number, $$3: Internal.TextureAtlasSprite_, $$4: Internal.Map_<ResourceLocation, Internal.TextureAtlasSprite>, $$5: Internal.CompletableFuture_<void>)
        mipLevel(): number;
        missing(): Internal.TextureAtlasSprite;
        readyForUpload(): Internal.CompletableFuture<void>;
        waitForUpload(): Internal.CompletableFuture<Internal.SpriteLoader$Preparations>;
        height(): number;
        width(): number;
        regions(): Internal.Map<ResourceLocation, Internal.TextureAtlasSprite>;
    }
    type SpriteLoader$Preparations_ = SpriteLoader$Preparations;
    interface IConfigManager {
        abstract getSettings(): Internal.Set<Internal.Setting<any>>;
        abstract getSetting<T extends Internal.Enum<T>>(arg0: Internal.Setting_<T>): T;
        abstract readFromNBT(arg0: Internal.CompoundTag_): boolean;
        hasSetting(setting: Internal.Setting_<any>): boolean;
        abstract writeToNBT(arg0: Internal.CompoundTag_): void;
        abstract putSetting<T extends Internal.Enum<T>>(arg0: Internal.Setting_<T>, arg1: T): void;
        abstract registerSetting<T extends Internal.Enum<T>>(arg0: Internal.Setting_<T>, arg1: T): void;
        get settings(): Internal.Set<Internal.Setting<any>>
    }
    type IConfigManager_ = IConfigManager;
    interface Thread$Builder$OfPlatform extends Internal.Thread$Builder {
        daemon(): this;
        abstract uncaughtExceptionHandler(arg0: Internal.Thread$UncaughtExceptionHandler_): this;
        abstract priority(arg0: number): this;
        abstract stackSize(arg0: number): this;
        abstract start(arg0: Internal.Runnable_): Internal.Thread;
        name(arg0: string, arg1: number): Internal.Thread$Builder;
        abstract inheritInheritableThreadLocals(arg0: boolean): this;
        abstract factory(): Internal.ThreadFactory;
        name(arg0: string): Internal.Thread$Builder;
        abstract group(arg0: Internal.ThreadGroup_): this;
        abstract daemon(arg0: boolean): this;
        abstract unstarted(arg0: Internal.Runnable_): Internal.Thread;
    }
    type Thread$Builder$OfPlatform_ = Thread$Builder$OfPlatform;
    class RetexturedBlockItem extends Internal.BlockTooltipItem {
        constructor(block: Internal.Block_, textureTag: Internal.TagKey_<Internal.Item>, builder: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        fillItemCategory(items: Internal.CreativeModeTab$Output_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        static setTexture(stack: Internal.ItemStack_, block: Internal.Block_): Internal.ItemStack;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static setTexture(stack: Internal.ItemStack_, name: string): Internal.ItemStack;
        setAttackSpeed(attackSpeed: number): void;
        static getTexture(stack: Internal.ItemStack_): Internal.Block;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static addTooltip(stack: Internal.ItemStack_, tooltip: Internal.List_<net.minecraft.network.chat.Component>): void;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        static getTextureName(stack: Internal.ItemStack_): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static addTagVariants(block: Internal.ItemLike_, tag: Internal.TagKey_<Internal.Item>, list: Internal.CreativeModeTab$Output_, showAllVariants: boolean): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RetexturedBlockItem_ = RetexturedBlockItem;
    interface Decoder$Simple <A> {
        abstract decode<T>(arg0: Internal.Dynamic_<T>): Internal.DataResult<A>;
        decoder(): Internal.Decoder<A>;
        (arg0: Internal.Dynamic<T>): Internal.DataResult_<A>;
    }
    type Decoder$Simple_<A> = Decoder$Simple<A>;
    class ParticleKeyframeEvent <T extends Internal.GeoAnimatable> extends Internal.KeyFrameEvent<T, Internal.ParticleKeyframeData> {
        constructor(animatable: T, animationTick: number, controller: Internal.AnimationController_<T>, particleKeyFrameData: Internal.ParticleKeyframeData_)
        getKeyframeData(): Internal.ParticleKeyframeData;
        get keyframeData(): Internal.ParticleKeyframeData
    }
    type ParticleKeyframeEvent_<T extends Internal.GeoAnimatable> = ParticleKeyframeEvent<T>;
    class BlockEntityRelay extends Internal.HexBlockEntity implements Internal.ILinkable, Internal.GeoBlockEntity, Internal.ILinkable$IRenderCentre {
        constructor(pos: BlockPos_, state: Internal.BlockState_)
        numLinked(): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        currentMediaLevel(): number;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        numRemainingIota(): number;
        triggerAnim(controllerName: string, animName: string): void;
        static "access$getLevel$p$s-1152931627"($this: Internal.BlockEntityRelay_): Internal.Level;
        getTick(blockEntity: any): number;
        getPos(): BlockPos;
        clearReceivedIotas(): void;
        onLoad(): void;
        serverTick(): void;
        getAnimData<D>(dataTicket: Internal.SerializableDataTicket_<D>): D;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        renderLinks(): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        nextReceivedIota(): Internal.Iota;
        renderCentre(other: Internal.ILinkable$IRenderCentre_, recursioning: boolean): Vec3d;
        getLinkableType(): Internal.LinkableRegistry$LinkableType<Internal.BlockEntityRelay, Internal.BlockEntityRelay>;
        animatableCacheOverride(): Internal.AnimatableInstanceCache;
        asComponentProvider(): Internal.ComponentProvider;
        checkLinks(): void;
        unlink(other: Internal.ILinkable_, unlinkOther: boolean): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        acceptMedia(other: Internal.ILinkable_, sentMedia: number): void;
        getClientLinkableHolder(): Internal.ClientLinkableHolder;
        setPigment(pigment: Internal.FrozenPigment_, level: Internal.Level_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        static access$setRelayNetwork$p($this: Internal.BlockEntityRelay_, <set-?>: Internal.BlockEntityRelay$RelayNetwork_): void;
        setAnimData<D>(dataTicket: Internal.SerializableDataTicket_<D>, data: D): void;
        getPosition(): Vec3d;
        allReceivedIotas(): Internal.List<Internal.Iota>;
        transmittingTargetReturnDisplay(): Internal.List<net.minecraft.network.chat.Component>;
        getBoneResetTime(): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAnimatableInstanceCache(): Internal.AnimatableInstanceCache;
        isInRange(other: Internal.ILinkable_): boolean;
        canAcceptMedia(other: Internal.ILinkable_, otherMediaLevel: number): number;
        debug(): void;
        shouldRemove(): boolean;
        receiveIota(sender: Internal.ILinkable_, iota: Internal.Iota_): void;
        pigment(): Internal.FrozenPigment;
        shouldPlayAnimsWhileGamePaused(): boolean;
        getLinkedIndex(linked: Internal.ILinkable_): number;
        getState(): Internal.BlockState;
        clientTick(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        maxSqrLinkRange(): number;
        getLinked(index: number): Internal.ILinkable;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getLinkableHolder(): Internal.ServerLinkableHolder;
        owner(): Internal.UUID;
        disconnectAll(): void;
        link(other: Internal.ILinkable_, linkOther: boolean): void;
        registerControllers(data: Internal.AnimatableManager$ControllerRegistrar_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        stopTriggeredAnim(controllerName: string, animName: string): void;
        getAsActionResult(): Internal.List<Internal.Iota>;
        get pos(): BlockPos
        get linkableType(): Internal.LinkableRegistry$LinkableType<Internal.BlockEntityRelay, Internal.BlockEntityRelay>
        get clientLinkableHolder(): Internal.ClientLinkableHolder
        get position(): Vec3d
        get boneResetTime(): number
        get animatableInstanceCache(): Internal.AnimatableInstanceCache
        get state(): Internal.BlockState
        get linkableHolder(): Internal.ServerLinkableHolder
        get asActionResult(): Internal.List<Internal.Iota>
        static readonly TAG_MEDIA_EXCHANGER: "relay:media_exchanger";
        static readonly TAG_PIGMENT_TIME: "hexal:pigment_time";
        static readonly TAG_PIGMENT: "hexal:pigment";
        static readonly MAX_SQR_LINK_RANGE: 1024.0;
        static readonly TAG_LINKABLE_HOLDER: "hexal:linkable_holder";
        static readonly Companion: Internal.BlockEntityRelay$Companion;
        static readonly TAG_RELAYS_LINKED_DIRECTLY: "hexal:relays_linked_directly";
        static readonly TAG_SYNC_NETWORK_ROOT: "relay:sync_network_root";
        static readonly TAG_NON_RELAYS_LINKED_DIRECTLY: "hexal:non_relays_linked_directly";
    }
    type BlockEntityRelay_ = BlockEntityRelay;
    class MagicLeavesBlock extends Internal.LeavesBlock {
        constructor(p_273704_: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MagicLeavesBlock_ = MagicLeavesBlock;
    interface TrapezoidHeightAccessor {
        abstract getMinInclusive(): Internal.VerticalAnchor;
        abstract getPlateau(): number;
        abstract getMaxInclusive(): Internal.VerticalAnchor;
        get minInclusive(): Internal.VerticalAnchor
        get plateau(): number
        get maxInclusive(): Internal.VerticalAnchor
    }
    type TrapezoidHeightAccessor_ = TrapezoidHeightAccessor;
    class DebugRenderer {
        constructor($$0: Internal.Minecraft_)
        static renderFloatingText($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: string, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: boolean, $$9: number, $$10: boolean): void;
        static renderFilledBox($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: Internal.AABB_, $$3: number, $$4: number, $$5: number, $$6: number): void;
        static renderFilledBox($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number, $$10: number, $$11: number): void;
        switchRenderChunkborder(): boolean;
        clear(): void;
        static renderFloatingText($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: string, $$3: number, $$4: number, $$5: number, $$6: number): void;
        static renderFilledBox($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: BlockPos_, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): void;
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource$BufferSource_, $$2: number, $$3: number, $$4: number): void;
        static renderFloatingText($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: string, $$3: number, $$4: number, $$5: number, $$6: number): void;
        static renderFloatingText($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: string, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number): void;
        static renderFilledBox($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: BlockPos_, $$3: BlockPos_, $$4: number, $$5: number, $$6: number, $$7: number): void;
        static getTargetedEntity($$0: Internal.Entity_, $$1: number): Internal.Optional<Internal.Entity>;
        readonly collisionBoxRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly villageSectionsDebugRenderer: Internal.VillageSectionsDebugRenderer;
        readonly worldGenAttemptRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly pathfindingRenderer: Internal.PathfindingRenderer;
        readonly goalSelectorRenderer: Internal.GoalSelectorDebugRenderer;
        readonly heightMapRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly lightDebugRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly gameTestDebugRenderer: Internal.GameTestDebugRenderer;
        readonly neighborsUpdateRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly supportBlockRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly brainDebugRenderer: Internal.BrainDebugRenderer;
        readonly beeDebugRenderer: Internal.BeeDebugRenderer;
        readonly skyLightSectionDebugRenderer: Internal.LightSectionDebugRenderer;
        readonly chunkRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly solidFaceRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly chunkBorderRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
        readonly structureRenderer: Internal.StructureRenderer;
        readonly raidDebugRenderer: Internal.RaidDebugRenderer;
        readonly gameEventListenerRenderer: Internal.GameEventListenerRenderer;
        readonly waterDebugRenderer: Internal.DebugRenderer$SimpleDebugRenderer;
    }
    type DebugRenderer_ = DebugRenderer;
    abstract class RotatableLamp extends Internal.LampBase implements Internal.SimpleWaterloggedBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid(world: Internal.BlockGetter_, blockpos: BlockPos_, blockState: Internal.BlockState_, fluid: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        DOWN: Internal.VoxelShape;
        EAST: Internal.VoxelShape;
        WEST: Internal.VoxelShape;
        NORTH: Internal.VoxelShape;
        UP: Internal.VoxelShape;
        SOUTH: Internal.VoxelShape;
    }
    type RotatableLamp_ = RotatableLamp;
    interface RegistryEntryAddedCallback <T> {
        event<T>(registry: Internal.Registry_<T>): net.fabricmc.fabric.api.event.Event<Internal.RegistryEntryAddedCallback<T>>;
        abstract onEntryAdded(arg0: number, arg1: ResourceLocation_, arg2: T): void;
        (arg0: number, arg1: ResourceLocation, arg2: T): void;
    }
    type RegistryEntryAddedCallback_<T> = RegistryEntryAddedCallback<T>;
    interface FabricLanguageProvider$TranslationBuilder {
        add(existingLanguageFile: Internal.Path_): void;
        abstract add(arg0: string, arg1: string): void;
        add(item: Internal.Item_, value: string): void;
        add(block: Internal.Block_, value: string): void;
        add(statusEffect: Internal.MobEffect_, value: string): void;
        add(identifier: ResourceLocation_, value: string): void;
        add(registryKey: Internal.ResourceKey_<Internal.CreativeModeTab>, value: string): void;
        add(enchantment: Internal.Enchantment_, value: string): void;
        add(statType: Internal.StatType_<any>, value: string): void;
        add(entityAttribute: Internal.Attribute_, value: string): void;
        add(entityType: Internal.EntityType_<any>, value: string): void;
        (arg0: string, arg1: string): void;
    }
    type FabricLanguageProvider$TranslationBuilder_ = FabricLanguageProvider$TranslationBuilder;
    interface Display$GenericInterpolator <T> {
        abstract get(arg0: number): T;
        constant<T>($$0: T): this;
        (arg0: number): T;
    }
    type Display$GenericInterpolator_<T> = Display$GenericInterpolator<T>;
    class FrameTimer {
        constructor()
        scaleSampleTo($$0: number, $$1: number, $$2: number): number;
        getLog(): number[];
        getAverageDuration($$0: number): number;
        logFrameDuration($$0: number): void;
        scaleAverageDurationTo($$0: number, $$1: number): number;
        getLogStart(): number;
        getLogEnd(): number;
        wrapIndex($$0: number): number;
        get log(): number[]
        get logStart(): number
        get logEnd(): number
        static readonly LOGGING_LENGTH: 240;
    }
    type FrameTimer_ = FrameTimer;
    class PineTreeFeature extends Internal.BOPTreeFeature<any> {
        constructor(codec: Internal.Codec_<any>)
    }
    type PineTreeFeature_ = PineTreeFeature;
}
declare namespace dev.engine_room.flywheel.api.material {
    class Transparency extends Internal.Enum<dev.engine_room.flywheel.api.material.Transparency> {
        static valueOf(name: string): dev.engine_room.flywheel.api.material.Transparency;
        static values(): dev.engine_room.flywheel.api.material.Transparency[];
        static readonly ADDITIVE: dev.engine_room.flywheel.api.material.Transparency;
        static readonly TRANSLUCENT: dev.engine_room.flywheel.api.material.Transparency;
        static readonly OPAQUE: dev.engine_room.flywheel.api.material.Transparency;
        static readonly CRUMBLING: dev.engine_room.flywheel.api.material.Transparency;
        static readonly LIGHTNING: dev.engine_room.flywheel.api.material.Transparency;
        static readonly GLINT: dev.engine_room.flywheel.api.material.Transparency;
        static readonly ORDER_INDEPENDENT: dev.engine_room.flywheel.api.material.Transparency;
    }
    type Transparency_ = "glint" | "additive" | "translucent" | Transparency | "lightning" | "opaque" | "crumbling" | "order_independent";
}
declare namespace com.electronwill.nightconfig.core.io {
    class ParsingMode extends Internal.Enum<com.electronwill.nightconfig.core.io.ParsingMode> {
        put(arg0: Internal.Map_<string, any>, arg1: string, arg2: any): any;
        static valueOf(arg0: string): com.electronwill.nightconfig.core.io.ParsingMode;
        put(arg0: Internal.Config_, arg1: Internal.List_<string>, arg2: any): any;
        static values(): com.electronwill.nightconfig.core.io.ParsingMode[];
        prepareParsing(arg0: Internal.Config_): void;
        put(arg0: Internal.Config_, arg1: string, arg2: any): any;
        static readonly REPLACE: com.electronwill.nightconfig.core.io.ParsingMode;
        static readonly MERGE: com.electronwill.nightconfig.core.io.ParsingMode;
        static readonly ADD: com.electronwill.nightconfig.core.io.ParsingMode;
    }
    type ParsingMode_ = "replace" | "merge" | ParsingMode | "add";
}
